% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_split_lines}
\alias{fmesher_split_lines}
\title{Split lines at triangle edges}
\usage{
fmesher_split_lines(mesh_loc, mesh_tv, loc, idx, options)
}
\arguments{
\item{mesh_loc}{numeric matrix; mesh vertex coordinates}

\item{mesh_tv}{3-column integer matrix with 0-based vertex indices for each triangle}

\item{loc}{numeric coordinate matrix}

\item{idx}{2-column integer matrix}

\item{options}{list of triangulation options (\code{sphere_tolerance})}
}
\value{
A list of line splitting information objects
}
\description{
Internal C++ method.

Split a sequence of line segments at triangle edges
}
\examples{
mesh <- fm_mesh_2d(
  boundary = fm_segm(rbind(c(0,0), c(1,0), c(1,1), c(0, 1)), is.bnd = TRUE)
)
splitter <- fm_segm(rbind(c(0.8, 0.2), c(0.2, 0.8)))
segm_split <- fm_split_lines(mesh, splitter)
}
\seealso{
\code{\link[=fm_split_lines]{fm_split_lines()}}
}
\keyword{internal}
