% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_network_graph_data.R
\name{bind_network_graph_data}
\alias{bind_network_graph_data}
\title{Bind network graph data}
\usage{
bind_network_graph_data(
  .,
  links_data = NULL,
  nodes_data = NULL,
  links_source = NULL,
  links_target = NULL,
  links_value = NULL,
  nodes_id = NULL,
  nodes_group = NULL,
  nodes_size = NULL,
  nodes_image = NULL,
  nodes_metadata = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{links_data}{Links data.}

\item{nodes_data}{Nodes data.}

\item{links_source}{Links source}

\item{links_target}{Links target}

\item{links_value}{Size by. A numerical value used to set the thickness of the links. Flourish type hint: column}

\item{nodes_id}{ID. A unique identifier for each point in the network. If not specified, point information will be extracted from the links sheet. Flourish type hint: column}

\item{nodes_group}{Color by. A group to which the point belongs. If set, can be used to color the points. Ignored if ID not set. Flourish type hint: column}

\item{nodes_size}{Size by. A numerical value used to size the points. Ignored if ID not set. Flourish type hint: column}

\item{nodes_image}{Image. An image to go into the circle. Flourish type hint: column}

\item{nodes_metadata}{Info for popups. One or more columns of information (text,  image URLs ,  embedded charts  etc) to include in  popups and panels Ignored if ID not set. Flourish type hint: columns}
}
\value{
A Flourish chart
}
\description{
Bind network graph data
}
\examples{
try(
  flourish(chart_type = "network", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_network_graph_data(gapminder)
)
}
