% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_hierarchy.R
\name{flag_hierarchy}
\alias{flag_hierarchy}
\title{Flag aggregation by the hierarchical inheritance method}
\usage{
flag_hierarchy(f, flag_list)
}
\arguments{
\item{f}{A vector of flags containing the flags of a series for a given set of flags.}

\item{flag_list}{The predefined hierarchy of allowed flags as a vector of single characters.}
}
\value{
\code{flag_hierarchy} returns the flag as single character that is the highest place in the
predifined hierarchy order for the given set of flags.
}
\description{
Flag aggregation by the hierarchical inheritance method
}
\examples{
flag_hierarchy(c("p","b","s","b","u","e","b"), flag_list = c("e","s","t"))
flag_hierarchy(c("p","b","s","c","u","d"), flag_list = c("e","s","t"))

flags <- tidyr::spread(test_data[, c(1:3)], key = time, value = flags)
flag_hierarchy(flags[,4],flag_list = c("p","b","s","c","u","e","d"))
apply(flags[, c(2:ncol(flags))],2, flag_hierarchy, flag_list = c("p","b","s","c","u","e","d"))

}
