% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sandy_311}
\alias{sandy_311}
\title{The (Very) Long Tail Of Hurricane Recovery}
\format{
A data frame with 1783 rows representing dates and 25 variables:
\describe{
\item{date}{Date}
\item{nyc_311}{No description provided.}
\item{acs}{The number of emergency hotline (311) calls made to the Administration for Children's Services related to Hurricane Sandy on the given date}
\item{bpsi}{The number of emergency hotline (311) calls made to Building Protection Systems, Inc related to Hurricane Sandy}
\item{cau}{The number of emergency hotline (311) calls made to the Community Affairs Unit related to Hurricane Sandy}
\item{chall}{The number of emergency hotline (311) calls made to the City Hall related to Hurricane Sandy}
\item{dep}{The number of emergency hotline (311) calls made to the Department of Environmental Protection related to Hurricane Sandy}
\item{dob}{The number of emergency hotline (311) calls made to the Department of Buildings related to Hurricane Sandy}
\item{doe}{The number of emergency hotline (311) calls made to the Department of Education related to Hurricane Sandy}
\item{dof}{The number of emergency hotline (311) calls made to the Department of Finance related to Hurricane Sandy}
\item{dohmh}{The number of emergency hotline (311) calls made to the Department of Health and Mental Hygiene related to Hurricane Sandy}
\item{dpr}{The number of emergency hotline (311) calls made to the Department of Parks and Recreation related to Hurricane Sandy}
\item{fema}{The number of emergency hotline (311) calls made to the Federal Emergency Management Agency related to Hurricane Sandy}
\item{hpd}{The number of emergency hotline (311) calls made to the Department of Housing Preservation and Development related to Hurricane Sandy}
\item{hra}{The number of emergency hotline (311) calls made to the Human Resources Administration related to Hurricane Sandy}
\item{mfanyc}{The number of emergency hotline (311) calls made to the Mayor's Fund to Advance NYC related to Hurricane Sandy}
\item{mose}{The number of emergency hotline (311) calls made to the Mayor's Office of Special Enforcement related to Hurricane Sandy}
\item{nycem}{The number of emergency hotline (311) calls made to Emergency Management related to Hurricane Sandy}
\item{nycha}{The number of emergency hotline (311) calls made to the New York City Housing Authority related to Hurricane Sandy}
\item{nyc_service}{The number of emergency hotline (311) calls made to NYC Service related to Hurricane Sandy}
\item{nypd}{The number of emergency hotline (311) calls made to the New York Police Department related to Hurricane Sandy}
\item{nysdol}{The number of emergency hotline (311) calls made to the NYC Department of Labor related to Hurricane Sandy}
\item{sbs}{The number of emergency hotline (311) calls made to Small Business Services related to Hurricane Sandy}
\item{nys_emergency_mg}{The number of emergency hotline (311) calls made to NYS Emergency Management related to Hurricane Sandy}
\item{total}{The total number of emergency hotline (311) calls made related to Hurricane Sandy}
}
}
\source{
Data from NYC Open Data \url{https://data.cityofnewyork.us/City-Government/311-Call-Center-Inquiry/tdd6-3ysr},
Agency acronyms from the Data Dictionary. See also \url{https://github.com/fivethirtyeight/data/tree/master/sandy-311-calls}
}
\usage{
sandy_311
}
\description{
The raw data behind the story
"The (Very) Long Tail Of Hurricane Recovery"
\url{https://projects.fivethirtyeight.com/sandy-311/}
}
\examples{
# To convert data frame to tidy data (long) format, run:
library(dplyr)
library(tidyr)
sandy_311_tidy <- sandy_311 \%>\%
  pivot_longer(-c("date", "total"), names_to = "agency", values_to = "num_calls") \%>\%
  arrange(date) \%>\%
  select(date, agency, num_calls, total) \%>\%
  rename(total_calls = total) \%>\%
  mutate(agency = as.factor(agency))
}
\keyword{datasets}
