% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{scores2wide}
\alias{scores2wide}
\title{Convert a scores file from long to wide format}
\usage{
scores2wide(scores, outfile=NA)
}
\arguments{
\item{scores}{a data frame read from the scorefile output of saveMarkeModels
in package fitPoly. The order of the markers within each sample does not have
to be the same or v.v., there is no requirement for any ordering of scores.
However if scores is not ordered by MarkerName and SampleName and/or not all
markers are present for all samples (or v.v.) this results in a slower
processing.}

\item{outfile}{a file name to which the result is written. If NA no file
is written.}
}
\value{
A data frame with column names marker, MarkerName and all sample
names, and one row per marker. Marker is the sequential number of the marker
as reported in the scores data frame.
}
\description{
The fitMarkers function of package fitPoly returns a
scores file in "long" format: one row for each MarkerName / SampleName
combination. This function creates a file in "wide" format (samples in
columns, markers in rows) containing the data from the geno column of the
scores file. Faster, less memory-expensive and easier to use than reshape.
}
