% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_key.R
\name{GuardKey}
\alias{GuardKey}
\title{R6 class for the Key guard}
\description{
This class encapsulates the logic of the key based authentication scheme. See
\code{\link[=guard_key]{guard_key()}} for more information
}
\examples{
# Create a guard of dubious quality
key <- GuardKey$new(
  key = "my-key-location",
  validate = "SHHH!!DONT_TELL_ANYONE"
)

}
\section{Super class}{
\code{\link[fireproof:Guard]{fireproof::Guard}} -> \code{GuardKey}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{location}}{The location of the secret in the request, either
\code{"cookie"} or \code{"header"}}

\item{\code{open_api}}{An OpenID compliant security scheme description}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GuardKey-new}{\code{GuardKey$new()}}
\item \href{#method-GuardKey-check_request}{\code{GuardKey$check_request()}}
\item \href{#method-GuardKey-reject_response}{\code{GuardKey$reject_response()}}
\item \href{#method-GuardKey-clone}{\code{GuardKey$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="forbid_user"><a href='../../fireproof/html/Guard.html#method-Guard-forbid_user'><code>fireproof::Guard$forbid_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="register_handler"><a href='../../fireproof/html/Guard.html#method-Guard-register_handler'><code>fireproof::Guard$register_handler()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardKey-new"></a>}}
\if{latex}{\out{\hypertarget{method-GuardKey-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardKey$new(key_name, validate, user_info = NULL, cookie = TRUE, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key_name}}{The name of the header or cookie to store the secret under}

\item{\code{validate}}{Either a single string with the secret
or a function that will be called with the arguments \code{key}, \code{request}, and
\code{response} and returns \code{TRUE} if its a valid secret (useful if you have
multiple or rotating secrets). If the function returns a character vector it
is considered to be authenticated and the return value will be understood as
scopes the user is granted. Make sure never to store secrets in plain text
and avoid checking them into version control.}

\item{\code{user_info}}{A function to extract user information from the
key. It is called with a single argument: \code{key} which is the key
used for the successful authentication. The function should return a new
\link[=new_user_info]{user_info} list.}

\item{\code{cookie}}{Boolean. Should the secret be transmitted as a cookie. If
\code{FALSE} it is expected to be transmitted as a header.}

\item{\code{name}}{The name of the guard}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardKey-check_request"></a>}}
\if{latex}{\out{\hypertarget{method-GuardKey-check_request}{}}}
\subsection{Method \code{check_request()}}{
A function that validates an incoming request, returning
\code{TRUE} if it is valid and \code{FALSE} if not. It extracts the secret from
either the cookie or header based on the provided \code{key_name} and test it
using the provided \code{validate} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardKey$check_request(request, response, keys, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to validate as a \link[reqres:Request]{Request}
object}

\item{\code{response}}{The corresponding response to the request as a
\link[reqres:Response]{Response} object}

\item{\code{keys}}{A named list of path parameters from the path matching}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardKey-reject_response"></a>}}
\if{latex}{\out{\hypertarget{method-GuardKey-reject_response}{}}}
\subsection{Method \code{reject_response()}}{
Upon rejection this guard sets the response status to \code{400}
if it has not already been set by others. In contrast to some of the other
guards which implements proper HTTP schemes, this one doesn't set a
\code{WWW-Authenticate} header.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardKey$reject_response(response, scope, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{The response object}

\item{\code{scope}}{The scope of the endpoint}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardKey-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GuardKey-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardKey$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
