% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_pos_compare}
\alias{fst_pos_compare}
\title{Compare parts-of-speech}
\usage{
fst_pos_compare(data, field, exclude_nulls = FALSE, rename_nulls = "null_data")
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format with additional `field`
column for splitting data.}

\item{field}{Column in `data` used for splitting groups}

\item{exclude_nulls}{Whether to include NULLs in `field` column, default is
`FALSE`}

\item{rename_nulls}{What to fill NULL values with if `exclude_nulls = FALSE`.}
}
\value{
Table of POS tag counts for the groups.
}
\description{
Count each POS type for different groups of participants. Data is split based
on different values in the `field` column of formatted data. Results will be
shown within the plots pane.
}
\examples{
fst_pos_compare(fst_child, 'gender')
fst_pos_compare(fst_dev_coop, 'region')
}
