% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_entropy.R
\name{relative_entropy}
\alias{relative_entropy}
\title{Relative Entropy}
\usage{
relative_entropy(prior, posterior)
}
\arguments{
\item{prior}{A prior probability distribution.}

\item{posterior}{A posterior probability distribution.}
}
\value{
A \code{double} with the relative entropy.
}
\description{
Computes the relative entropy of two distributions.
}
\examples{
set.seed(222)

prior <- rep(1 / 100, 100)

posterior <- runif(100)
posterior <- posterior / sum(posterior)

relative_entropy(prior, posterior)
}
