% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feistest.R
\name{bsfeistest}
\alias{bsfeistest}
\title{Bootstrapped Regression Test}
\usage{
bsfeistest(
  model = NA,
  type = c("all", "bs1", "bs2", "bs3"),
  terms = NULL,
  rep = 500,
  seed = NULL,
  prog = TRUE,
  ...
)
}
\arguments{
\item{model}{an object of class "\code{feis}".}

\item{type}{one of "\code{all}" (the Default), "\code{bs1}" for test of FEIS against FE only,
"\code{bs2}" for test of FE against RE only, and "\code{bs3}" for test of FEIS against RE only
(see also Details).}

\item{terms}{An optional character vector specifying which coefficients should be jointly tested.
By default, all covariates are included in the Wchi-squared test. For "\code{type=art2}", the
slope variable is always included in "\code{terms}".}

\item{rep}{the number of repetitions to be used in bootstrapping (default is 500).}

\item{seed}{the seed used for random sampling in bootstrapping. Needs to be a valid integer.
If not specified, the current seed is used.}

\item{prog}{...    logical. If \code{TRUE} (the Default) shows the progress in the output window.}

\item{...}{further arguments.}
}
\value{
An object of class "\code{feistest}", containing the following elements:
\item{wald_feis}{an object of class "\code{wald.test}"
 testing the fixed effects individual slopes model against the conventional fixed effects
 model (\code{type="bs1"}).}
\item{wald_fe}{an object of class "\code{wald.test}"
 testing the fixed effects model against the random effects model (\code{type="bs2"}).}
\item{wald_re}{an object of class "\code{wald.test}"
testing the fixed effects individual slopes model against the random effects model
(\code{type="bs3"}).}
\item{vcov1}{the empirical (bootstrapped) variance-covariance matrix of the
coefficients obtained from FEIS and FE (\code{type="bs1"}).}
\item{vcov2}{the empirical (bootstrapped) variance-covariance matrix of the
coefficients obtained from FE and RE (\code{type="bs2"}).}
\item{vcov3}{the empirical (bootstrapped) variance-covariance matrix of the
coefficients obtained from FEIS and RE (\code{type="bs3"}).}
\item{bscoef.feis}{a matrix containing the estimated FEIS coefficients of each bootstrap run.}
\item{bscoef.fe}{a matrix containing the estimated FE coefficients of each bootstrap run.}
\item{bscoef.re}{a matrix containing the estimated RE coefficients of each bootstrap run.}
\item{call}{the matched call.}
\item{formula}{an object of class "\code{Formula}" describing the model.}
\item{type}{the type of performed test(s).}
\item{sample}{a list containing the IDs sampled in each run.}
\item{seed}{the seed used for bootstrapping.}
\item{terms}{character vector of covariates are included in the Wchi-squared test.}
}
\description{
Estimates a bootstrapped Hausman test for fixed effects individual slope models.
}
\details{
The function computes a bootstrapped version of the Hausman test \insertCite{Hausman.1978.0}{feisr}.
Pairs cluster bootstrapping \insertCite{Cameron.2008,Ruttenauer.2020}{feisr} is used to obtain the empirical
variance-covariance matrix of the estimators, either for FEIS and conventional FE, convention FE and RE,
or FEIS and RE.

\code{type="bs1"} estimates a bootstrapped Hausman test comparing fixed effects individual slope
models and conventional fixed effects models. In this case, \code{bsfeistest} tests for
inconsistency of the convetional FE model due to heterogeneous slopes.
\code{type="bs2"} estimates a bootstrapped version of the well-known Hausman test comparing conventional
fixed effects models against random effects models.
\code{type="bs3"} estimates a bootstrapped Hausman directly comparing FEIS against RE, thereby testing
for inconsistency of the RE model due to either heterogeneous slopes or time-constant omitted heterogeneity.
Bootstrapping is perfomed by resampling with replacement while keeping the number of groups identical to
the number of groups in the original dataset. A wald test from aod package is used to perform a Wald
chi-squared test on the differences between coefficients.
}
\examples{
data("mwp", package = "feisr")
\dontrun{
feis.mod <- feis(lnw ~ marry + enrol | year,
                 data = mwp, id = "id", robust = TRUE)
bsht <- bsfeistest(feis.mod, type = "bs1", rep = 100, seed = 1234)
summary(bsht)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[feisr]{summary.feistest}}, \code{\link[feisr]{feistest}},
\code{\link[feisr]{feis}},  \code{\link[plm]{plm}},
\code{\link[plm]{phtest}}
}
