% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dens2quantile.R
\name{dens2quantile}
\alias{dens2quantile}
\title{Function for converting Densities to Quantile Functions}
\usage{
dens2quantile(
  dens,
  dSup = seq(0, 1, length.out = length(dens)),
  qSup = seq(0, 1, length.out = length(dens)),
  useSplines = TRUE
)
}
\arguments{
\item{dens}{density on dSup}

\item{dSup}{support for Density domain - max and min values mark the boundary of the support.}

\item{qSup}{support for quantile domain - must begin at 0 and end at 1}

\item{useSplines}{fit spline to the qd when doing the numerical integration (default: TRUE)}
}
\value{
Q quantile function on qSup
}
\description{
Function for converting Densities to Quantile Functions
}
\examples{

x <- seq(0,2,length.out =512)
y <- rep(0.5,length.out =512)
y.quantile <- dens2quantile(dens=y, dSup = x) # should equate # 2*seq(0, 1, length.out = 512)

}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
\seealso{
\code{\link{normaliseDensities}}
}
