% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_replace.R
\name{ft_replace_pattern}
\alias{ft_replace_pattern}
\title{Replace Parts of Factor Levels Based on a Pattern}
\usage{
ft_replace_pattern(factor_vec, pattern, replacement, replace_all = TRUE)
}
\arguments{
\item{factor_vec}{A factor vector to be modified.}

\item{pattern}{A regular expression pattern to match.}

\item{replacement}{A string to replace the matched parts.}

\item{replace_all}{Logical. If \code{TRUE} (default), all occurrences of the pattern are replaced. If \code{FALSE}, only the first occurrence is replaced.}
}
\value{
A factor vector with levels modified.
}
\description{
Replaces parts of the factor levels that match a specified pattern with a new string.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple_pie', 'banana_bread', 'cherry_cake'))

# Replace '_pie', '_bread', '_cake' with '_dessert' (all occurrences)
ft_replace_pattern(factor_vec, pattern = '_.*', replacement = '_dessert')

# Replace only the first occurrence of '_' with '-'
ft_replace_pattern(factor_vec, pattern = '_', replacement = '-', replace_all = FALSE)
}
\author{
Kai Guo
}
