% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{predict.fairadaptBoot}
\alias{predict.fairadaptBoot}
\title{Prediction function for new data from a saved \code{fairadaptBoot} object}
\usage{
\method{predict}{fairadaptBoot}(object, newdata, ...)
}
\arguments{
\item{object}{Object of class \code{fairadapt}, a result of an adaptation
procedure.}

\item{newdata}{A \code{data.frame} containing the new data.}

\item{...}{Additional arguments forwarded to \code{computeQuants()}.}
}
\value{
A \code{data.frame} containing the adapted version of the new data.
}
\description{
Prediction function for new data from a saved \code{fairadaptBoot} object
}
\details{
The \code{newdata} argument should be compatible with \code{adapt.test}
argument that was used when constructing the \code{fairadaptBoot} object. In
particular, \code{newdata} should contain column names that appear in the
\code{formula} argument that was used when calling \code{fairadaptBoot()} (apart from
the outcome variable on the LHS of the formula).
}
\examples{
n_samp <- 200
uni_dim <- c(       "gender", "edu", "test", "score")
uni_adj <- matrix(c(       0,     1,      1,       0,
                           0,     0,      1,       1,
                           0,     0,      0,       1,
                           0,     0,      0,       0),
                  ncol = length(uni_dim),
                  dimnames = rep(list(uni_dim), 2),
                  byrow = TRUE)

uni_ada_boot <- fairadaptBoot(score ~ .,
  train.data = head(uni_admission, n = n_samp),
  adj.mat = uni_adj,
  prot.attr = "gender",
  n.boot = 5,
  keep.object = TRUE
)

predict(object = uni_ada_boot, newdata = tail(uni_admission, n = n_samp))
}
