% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{ezknitr_core}
\alias{ezknitr_core}
\alias{ezspin}
\alias{ezknit}
\title{Knit Rmd or spin R files without the typical pain of working directories}
\usage{
ezspin(
  file,
  wd,
  out_dir,
  fig_dir,
  out_suffix,
  params = list(),
  verbose = FALSE,
  chunk_opts = list(tidy = FALSE),
  keep_rmd = FALSE,
  keep_md = TRUE,
  keep_html = TRUE,
  move_intermediate_file = TRUE,
  ...
)

ezknit(
  file,
  wd,
  out_dir,
  fig_dir,
  out_suffix,
  params = list(),
  verbose = FALSE,
  chunk_opts = list(tidy = FALSE),
  keep_md = TRUE,
  keep_html = TRUE
)
}
\arguments{
\item{file}{The path to the input file (.Rmd file if using \code{ezknit} or 
.R script if using \code{ezspin}). If \code{wd} is provided, then this path is 
relative to \code{wd}.}

\item{wd}{The working directory to be used in the Rmd/R script. Defaults to
the current working directory (note that this is not the same behaviour as
\code{knitr}). See the 'Detailed Arguments' section for more details.}

\item{out_dir}{The output directory for the rendered markdown or HTML files
(if \code{wd} is provided, then this path is relative to \code{wd}).
Defaults to the directory containing the input file.}

\item{fig_dir}{The name (or path) of the directory where figures should
be generated. See the 'Detailed Arguments' section for more details.}

\item{out_suffix}{A suffix to add to the output files. Can be used to
differentiate outputs from runs with different parameters. The name of the
output files is the name of the input file appended by \code{out_suffix},
separated by a dash.}

\item{params}{A named list of parameters to be passed to use in the input
Rmd/R file. For example, if the script to execute assumes that there is a
variable named \code{DATASET_NAME}, then you can use
\code{params = list('DATASET_NAME' = 'oct10dat')}.}

\item{verbose}{If TRUE, then show the progress of knitting the document.}

\item{chunk_opts}{List of knitr chunk options to use. See 
\code{?knitr::opts_chunk} for a list of available chunk options.}

\item{keep_rmd, keep_md}{Should intermediate \code{Rmd} or \code{md} files be
kept (\code{TRUE}) or deleted (\code{FALSE})?}

\item{keep_html}{Should the final \code{html} file be kept (\code{TRUE})
or deleted (\code{FALSE})?}

\item{move_intermediate_file}{Should the intermediate \code{Rmd} file be
moved to the output folder (\code{TRUE}) or stay in the same folder as
the source \code{R} file (\code{FALSE})?}

\item{...}{Any extra parameters that should be passed to \code{knitr::spin}.}
}
\value{
The path to the output directory (invisibly).
}
\description{
\code{ezknitr} is an extension of \code{knitr} that adds flexibility in several
ways. One common source of frustration with \code{knitr} is that it assumes
the directory where the source file lives should be the working directory,
which is often not true. \code{ezknitr} addresses this problem by giving you
complete control over where all the inputs and outputs are, and adds several
other convenient features. The two main functions are \code{ezknit} and 
\code{ezspin}, which are wrappers around \code{knitr}'s \code{knit} and
\code{spin}, used to make rendering markdown/HTML documents easier.
}
\details{
If you have a very simple project with a flat directory structure, then
\code{knitr} works great. But even something as simple as trying to knit a 
document that reads a file from a different directory or placing the output 
rendered files in a different folder cannot be easily done with \code{knitr}.

\code{ezknitr} improves basic \code{knitr} functionality in a few ways.
You get to decide:
\itemize{
  \item What the working directory of the source file is
  \item Where the output files will go
  \item Where the figures used in the markdown will go
  \item Any parameters to pass to the source file
}
}
\section{Detailed Arguments}{

All paths given in the arguments can be either absolute or relative.

The \code{wd} argument is very important and is set to the current working
directory by default. The path of the input file and the path of the output
directory are both relative to \code{wd} (unless they are absolute paths).
Moreover, any code in the R script that reads or writes files will use
\code{wd} as the working directory.

The \code{fig_dir} argument is relative to the output directory, since the
figures accompanying a markdown file should be placed in the same
directory. It is recommended to either leave \code{fig_dir} as default or
set it to a different name but not to a different directory. Because of the
way \code{knitr} works, there are a few known minor issues if \code{fig_dir}
is set to a different directory.
}

\section{Difference between ezknit and ezspin}{

\code{ezknit} is a wrapper around \code{knitr::knit} while \code{ezspin}
is a wrapper around \code{ezspin}. The two functions are very similar.
\code{knit} is the more popular and well-known function. It is used
 to render a markdown/HTML document from an Rmarkdown source. 
\code{spin} takes an R script as its input, produces an
Rmarkdown document from the R script, and then calls \code{knit} on it.
}

\examples{
\dontrun{
   tmp <- setup_ezknit_test()
   ezknit("R/ezknit_test.Rmd", wd = "ezknitr_test")
   ezknit("R/ezknit_test.Rmd", wd = "ezknitr_test",
          out_dir = "output", fig_dir = "coolplots",
          params = list(numPoints = 50))
   open_output_dir()
   unlink(tmp, recursive = TRUE, force = TRUE)
 
   tmp <- setup_ezspin_test()
   ezspin("R/ezspin_test.R", wd = "ezknitr_test")
   ezspin("R/ezspin_test.R", wd = "ezknitr_test",
          out_dir = "output", fig_dir = "coolplots",
          params = list(numPoints = 50), keep_rmd = TRUE)
   open_output_dir()
   unlink(tmp, recursive = TRUE, force = TRUE)
}
}
\seealso{
\code{\link[ezknitr]{open_output_dir}}
\code{\link[ezknitr]{setup_ezknit_test}}
\code{\link[ezknitr]{setup_ezspin_test}}
\code{\link[ezknitr]{set_default_params}}
\code{\link[knitr]{knit}}
\code{\link[knitr]{spin}}
}
