% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes-ECM.R
\name{summary.BayesECMpred}
\alias{summary.BayesECMpred}
\title{Summary of Unlabeled Event Categorization}
\usage{
\method{summary}{BayesECMpred}(object, index = 1, category = 1, C = 1 - diag(2), ...)
}
\arguments{
\item{object}{an object of \code{class} \code{"BayesECMpred"} obtained as the output from the \code{\link[=predict.BayesECM]{predict.BayesECM()}} function.}

\item{index}{integer stipulating the event of interest.  Value corresponds to the row index of \code{Ytilde} previously supplied to \code{\link[=predict.BayesECM]{predict.BayesECM()}}}

\item{category}{integer for the index of the category of interest for hypothesis testing.  Alternatively, a character string naming the category of interest can be provided.}

\item{C}{square matrix of dimension 2, providing loss values to be used in hypothesis testing.  See Details.}

\item{...}{not used}
}
\value{
Prints a summary including probability of each category for the event stipulated by \code{index}, minimum expected loss for binary categorization, and probability of a-typicality of the event for the category specified by \code{category}.
}
\description{
Tabulates results from the \code{\link[=predict.BayesECM]{predict.BayesECM()}} function for quick analysis.
}
\details{
\subsection{Expected Loss}{

\code{\link[=summary.BayesECMpred]{summary.BayesECMpred()}} prints expected loss for the binary hypothesis stipulated by \code{category}.  Expected loss is calculated using the loss matrix specified with argument \code{C}.  The default values for \code{C} result in 0-1 loss being used.  Format details for the loss matrix can be found in \code{vignette("syn-data-code")}.
}

\subsection{Typicality}{

Typicality indices are used in \code{\link[=cECM_decision]{cECM_decision()}} as part of the decision criteria.  Here, we have adapted typicality indices for use with a Bayesian ECM model for outlier detection, when a new observation may not be related to the categories used for training.  Probability of the p-value being less than a significance level of 0.05 is reported.  If no missing data is used for training, this probability is either 0 or 1.
}
}
\examples{

csv_use <- "good_training.csv"
file_path <- system.file("extdata", csv_use, package = "ezECM")
training_data <- import_pvals(file = file_path, header = TRUE, sep = ",", training = TRUE)

trained_model <- BayesECM(Y = training_data, BT = c(10,1000))

csv_use <- "good_newdata.csv"
file_path <- system.file("extdata", csv_use, package = "ezECM")
new_data <- import_pvals(file = file_path, header = TRUE, sep = ",", training = TRUE)

bayespred <- predict(trained_model,  Ytilde = new_data)


}
