% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwave-depth.R
\name{P_wave_gen}
\alias{P_wave_gen}
\title{Generation of noisy p-wave arrival times}
\usage{
P_wave_gen(
  Si = NULL,
  S0 = NULL,
  Sig = NULL,
  neg.obs = TRUE,
  eps = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{Si}{Numeric matrix providing seismometer locations.  Must contain 3 columns corresponding to (X,Y) corrdinates and depth.}

\item{S0}{Numeric 3 element vector stipulating the location of an event, elements correspond to (X, Y, Z)}

\item{Sig}{Numeric vector, or diagonal matrix, providing the variance in observed arrival times at each seismometer.}

\item{neg.obs}{Logical indicating whether to allow negative observations of time (eg. the observed time of p-wave arrival is before the true time for the event).}

\item{eps}{Numeric.  If \code{neg.obs = FALSE} sets of observations are redrawn until all \eqn{t_i - t_0 \leq} \code{eps}.}
}
\value{
Numeric vector of observation times that correspond to the rows of \code{Si}
}
\description{
Similar utility to \link{time_fn}, however multiple seismometer locations can be provided simultaneously and normally distributed noise is added to the arrival time.
}
\examples{

pwave.obs <- P_wave_gen(Si = c(100,200,3), S0 = c(400, 500, 4), Sig = 0.05)

}
