% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiles.R
\name{quant}
\alias{quant}
\alias{quant.evmm}
\title{Estimated Quantiles}
\usage{
quant(x, ...)

\method{quant}{evmm}(x, values = NULL, cred = 0.95, ...)
}
\arguments{
\item{x}{the output of a model estimated with \code{extrememix}.}

\item{...}{additional arguments for compatibility.}

\item{values}{numeric vector of values of which to compute the quantile.}

\item{cred}{amplitude of the posterior credibility interval.}
}
\value{
A list with the following entries: \itemize{
\item \code{quantiles}: a matrix containing the quantiles, the posterior credibility intervals and the empirical estimate.
\item \code{data}: the dataset used to estimate the quantiles.
\item \code{complete}: a matrix with the quantiles for each value in the posterior sample.
}
}
\description{
Computation of posterior quantiles for an extreme value mixture model
}
\details{
For a random variable \eqn{X} the p-quantile is the value \eqn{x} such that \eqn{P(X>x)=1-p}. For an extreme value mixture model this can be computed as
\deqn{x = u +\frac{\sigma}{\xi}((1-p^*)^{-\xi}-1),}
where \deqn{p^* = \frac{p-F_\textnormal{bulk}(u|\theta)}{1-F_\textnormal{bulk}(u|\theta)},}
and \eqn{F_\textnormal{bulk}} is the distribution function of the bulk, parametrized by \eqn{\theta}.
}
\examples{
quant(rainfall_ggpd)


}
\references{
do Nascimento, Fernando Ferraz, Dani Gamerman, and Hedibert Freitas Lopes. "A semiparametric Bayesian approach to extreme value estimation." Statistics and Computing 22.2 (2012): 661-675.
}
