% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fggpd.R
\name{fggpd}
\alias{fggpd}
\title{GGPD Estimation}
\usage{
fggpd(x, it, start = NULL, var = NULL, prior = NULL, thin = 1, burn = 0)
}
\arguments{
\item{x}{A vector of positive observations.}

\item{it}{Number of iterations of the algorithm.}

\item{start}{A list of starting parameter values.}

\item{var}{A list of starting proposal variances.}

\item{prior}{A list of hyperparameters for the prior distribution.}

\item{thin}{Thinning interval.}

\item{burn}{Burn-in length.}
}
\value{
\code{fggpd} returns a list with three elements: \itemize{
\item \code{chain}: a matrix of size (\code{it} - \code{burn})/\code{thin}\eqn{\times}5, reporting in each column the posterior sample for each parameter.
\item \code{var}: a matrix of size \code{it}\eqn{\times}5 reporting the variance of the proposal distribution for each parameter.
\item \code{data}: the dataset used for estimation.
}
}
\description{
Fit of the GGPD model using an MCMC algorithm.
}
\details{
Estimation of the GGPD is carried out using an adaptive block Metropolis-Hastings algorithm. As standard, the user needs to specify the data to use during estimation, the number of iterations of the algorithm, the burn-in period (by default equal to zero) and the thinning interval (by default equal to one).
To run the algorithm it is also needed the choice of the starting values, the starting values of the proposal variances, and the parameters of the prior distribution. If not provided, these are automatically set as follows:
\itemize{
\item \emph{starting values}: \eqn{u} is chosen by the function \code{ithresh} of the \code{threshr} package; \eqn{\xi} and \eqn{\sigma} are chosen by the \code{fpot} function of \code{evd} for data over the threshold; \eqn{\mu} and \eqn{\eta} are chosen as the maximum likelihood estimate of the Gamma distribution over data below the threshold.
\item \emph{variances}: variances are chosen as the standard deviation of the normal distribution whose 0.01 quantile is equal to 0.9 times the starting value of the associated parameter.
\item \emph{prior distributions}: the prior distribution for \eqn{\xi} and \eqn{\sigma} is the objective prior \deqn{p(\xi,\sigma) = \sigma^{-1}(1+\xi)^{-1}(1+2\xi)^{-1/2}.} The prior for the threshold \eqn{u} is Normal with mean chosen as for the starting values and the standard deviation is chosen so that the 0.05 quantile of the prior is equal to the median of the data. The priors for the parameters \eqn{\mu} and \eqn{\eta} are Gammas with mean chosen as for the starting values and shapes equal to 0.001 so to give high prior variances.
}

The user can also select any of the three inputs above. \itemize{
\item The starting values \code{start} must be a list with entries \code{xi}, \code{sigma}, \code{u}, \code{mu}, \code{eta}.
\item The variances \code{var} must be a list with entries \code{xi}, \code{sigma}, \code{u}, \code{mu}, \code{eta}.
\item The prior \code{prior} must be a list with entries \code{u}, \code{mu}, \code{eta} all containing a vector of length two (for \code{u} giving the mean and the standard deviation of the Normal prior, for \code{mu} and \code{eta} giving the mean and shape of the Gamma prior).}
}
\examples{
\donttest{
## Small number of iterations and burn-in for quick execution
data(rainfall)
model1 <- fggpd(rainfall, it = 250, burn = 50, thin = 25)

start <- list(xi = 0.2, sigma = 2, u = 10, mu = 5, eta = 2)
var <- list(xi = 0.01, sigma = 1, u = 3, mu = 3, eta = 1)
prior <- list(u = c(22,5), mu = c(4,16), eta = c(0.001,0.001))
model2 <- fggpd(rainfall,it = 250, start = start, var =var, prior = prior)
}

}
\references{
Behrens, Cibele N., Hedibert F. Lopes, and Dani Gamerman. "Bayesian analysis of extreme events with threshold estimation." Statistical Modelling 4.3 (2004): 227-244.

do Nascimento, Fernando Ferraz, Dani Gamerman, and Hedibert Freitas Lopes. "A semiparametric Bayesian approach to extreme value estimation." Statistics and Computing 22.2 (2012): 661-675.
}
\seealso{
\code{\link{ggpd}}
}
