% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{hill}
\alias{hill}
\title{Hill estimator}
\usage{
hill(X, weights = rep(1, length(X)), grid = X)
}
\arguments{
\item{X}{a vector of data.}

\item{weights}{a vector of weights assiociated to \eqn{x}.}

\item{grid}{a vector of values for which the Hill estimator is computed.}
}
\value{
\item{xsort}{the sorted data.}
\item{wsort}{the weights assiociated to \eqn{xsort}.}
\item{grid}{the grid for which the Hill estimator is computed.}
\item{hill}{the Hill estimators.}
}
\description{
Compute the weighted Hill estimator.
}
\details{
Compute the weighted Hill estimator for vectors \eqn{grid}, data and weights (see references below).
}
\examples{
X <- abs(rcauchy(100))
weights <- rep(1, length(X))
wh <- hill(X, w = weights)
}
\references{
Grama, I. and Spokoiny, V. (2008). Statistics of extremes by oracle estimation. Ann. of Statist., 36, 1619-1648.

Durrieu, G. and Grama, I. and Pham, Q. and Tricot, J.- M (2015). Nonparametric adaptive estimator of extreme conditional tail probabilities quantiles. Extremes, 18, 437-478.

Hill, B.M. (1975). A simple general approach to inference about the tail of a distribution. Annals of Statistics, 3, 1163-1174.
}
\author{
Ion Grama
}
