% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize}
\alias{standardize}
\title{Standardize Variables}
\usage{
standardize(data, variable, type = "absolute")
}
\arguments{
\item{data}{data.frame object that contains both the dependent variable and predictor variables you want to regress.}

\item{variable}{variable name or vector of names for variables you want standardized.}

\item{type}{by default, 'absolute' will scale every variable from 0 to 1.  "classic" is a little more complicated where the variable is rescaled the mean equaling 0 and a standard deviation is 1.}
}
\value{
if the function is passed a single variable to standardize, it will return a vector of all obeservations in the variable standardized.  If the function is passed more than one variable name, it will return a data-frame containing the new observation values.
}
\description{
This function takes in a dataframe, the name of any number of variables.  It then returns either a vector or a dataframe of scaling results.  If passed a single variable name, standardize will return a the standardized variable as a vector, when passed 2 or more variable names, standardize will return a data frame containing all of the standardized variables.
}
\details{
Often times we are forced to compare variables which exist on different scales, but how do you compare the coefficient for a country's population to one that's much smaller?  Standardizing your variables can make reading regression results more useful because it will make coeficients more comparable.
}
\examples{
exam.df <- iris
standardize(exam.df, "Petal.Width")
standardize(exam.df, c("Petal.Width", "Petal.Length"), type = "classic")
}

