% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_bootstrap.R
\name{plot.extboot}
\alias{plot.extboot}
\title{Plot Method for 'extboot' Class}
\usage{
\method{plot}{extboot}(x, title = "Exact Bootstrap Distribution", ...)
}
\arguments{
\item{x}{An object of class 'extboot', usually the output of the \code{\link{exact_bootstrap}} function.}

\item{title}{A plot title. Default is "Exact Bootstrap Distribution".}

\item{...}{Additional parameters (currently ignored).}
}
\value{
A ggplot object showing the density estimates of the bootstrap sample statistic.
}
\description{
Creates a plot of the density estimates of the bootstrap sample statistics
returned from the \code{\link{exact_bootstrap}} function.
}
\examples{
set.seed(123)
data <- rnorm(5)
result <- exact_bootstrap(data)
plot(result)
}
\seealso{
\code{\link{exact_bootstrap}}, \code{\link{summary.extboot}}
}
