% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_bootstrap.R
\name{exact_bootstrap}
\alias{exact_bootstrap}
\title{Performs an Exact Bootstrap with Summary Statistics}
\usage{
exact_bootstrap(
  data,
  check_size = TRUE,
  anon = function(x) (mean(x)),
  lb = 0.025,
  ub = 0.975,
  density_args
)
}
\arguments{
\item{data}{A numeric vector of data points.}

\item{check_size}{A logical value indicating whether to check if the size of the
dataset is less than 10. Default is TRUE.}

\item{anon}{A function to compute the sample statistic for each bootstrap
sample. Default is the mean function.}

\item{lb}{Lower bound for the confidence interval. Default is 0.025.}

\item{ub}{Upper bound for the confidence interval. Default is 0.975.}

\item{density_args}{Pass additional arguments to stats::density}
}
\value{
A list with two elements: \itemize{
\item dens: a density estimate of the bootstrap sample statistics,
\item stats: a list of summary statistics including number of resamples, mode,
median, mean, standard deviation, lower confidence interval (lCI), and upper
confidence interval (uCI).}
}
\description{
Performs an exact bootstrap method on small datasets and returns
a set of summary statistics. This function implements a popular variant of exact
bootstrapping where the total number of combinations is expressed as N^N
(i.e., the vector c(1 ,2, 7) has 3^3 = 27 combinations rather than the 10
combinations obtained from exact case bootstrapping), giving more weight to a
resample with larger variation, thus potentially increasing the bootstrap
estimate's accuracy. This technique is described in Kisielinska (2013).
}
\examples{
set.seed(123)
data <- rnorm(5)
result <- exact_bootstrap(data)
summary(result)
plot(result)
}
\references{
Kisielinska, J. (2013). The exact bootstrap method shown on the example of the mean and variance estimation. Computational Statistics, 28, 1061–1077. \doi{https://doi.org/10.1007/s00180-012-0350-0}
}
\seealso{
\code{\link{plot.extboot}}, \code{\link{summary.extboot}}
}
