% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_media}
\alias{send_media}
\title{Send media (image, video, document)}
\usage{
send_media(
  client,
  number,
  mediatype,
  mimetype,
  media,
  file_name,
  caption = NULL,
  delay = NULL,
  link_preview = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient number with country code
(e.g., \code{"5581999990000"} or \code{"+5581999990000"}).}

\item{mediatype}{One of \code{"image"}, \code{"video"}, \code{"document"}.}

\item{mimetype}{MIME type string, e.g., \code{"image/png"}, \code{"video/mp4"},
\code{"application/pdf"}.}

\item{media}{The media content. Can be: (a) an HTTP/HTTPS URL;
(b) a local file path; (c) raw base64; or
(d) a data-URI (\verb{data:*;base64,...}).}

\item{file_name}{Suggested filename for the recipient
(should match the MIME type, e.g., \code{"report.pdf"}).}

\item{caption}{Optional caption text displayed with the media.}

\item{delay}{Integer (ms). Optional presence delay before sending.
Simulates typing before the message is sent.}

\item{link_preview}{Logical. Enable URL link preview in the message.}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Sends an image, video, or document via Evolution API v2.
The \code{media} argument is flexible: it accepts an HTTP(S) URL, a local
file path (auto-encoded to base64), raw base64, or a data-URI.
}
\examples{
\dontrun{
# From URL
send_media(client, "5581999990000", "image", "image/png",
           media = "https://www.r-project.org/logo/Rlogo.png",
           file_name = "Rlogo.png", caption = "R Logo")

# From local file
send_media(client, "5581999990000", "document", "application/pdf",
           media = "report.pdf", file_name = "report.pdf")
}
}
