% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{check_is_whatsapp}
\alias{check_is_whatsapp}
\title{Check if numbers are on WhatsApp}
\usage{
check_is_whatsapp(client, numbers, verbose = FALSE)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{numbers}{Character vector of phone numbers to check (with country
code, e.g., \code{"5581999990000"}).}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details.}
}
\value{
A named list (or data frame) from the API indicating which
numbers are registered. The HTTP status code is stored in
\code{attr(result, "http_status")}.
}
\description{
Verifies whether one or more phone numbers are registered
on WhatsApp using the Evolution API v2 chat controller endpoint.
}
\examples{
\dontrun{
check_is_whatsapp(client, c("5581999990000", "5511988887777"))
}
}
