% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_tools.R
\name{idigamma}
\alias{idigamma}
\alias{Ddigamma}
\alias{Dtrigamma}
\alias{gammap}
\title{Polygamma Functions}
\usage{
idigamma(x)

Ddigamma(x, y)

Dtrigamma(x, y)

gammap(x, p, log = FALSE)
}
\arguments{
\item{x, y}{numeric. The points to evaluate the function.}

\item{p}{integer. The p-variate Gamma function.}

\item{log}{logical. Should the logarithm of the result be returned?}
}
\value{
numeric. The evaluated function.
}
\description{
This set of functions revolve around the polygamma functions.
}
\section{Functions}{
\itemize{
\item \code{idigamma()}: inverse digamma function.

\item \code{Ddigamma()}: digamma difference function.

\item \code{Dtrigamma()}: trigamma difference function.

\item \code{gammap()}: p-variate gamma function

}}
\examples{
idigamma(2)
Ddigamma(2, 3)
Dtrigamma(2, 3)
gammap(1:3, 3)
}
