% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_calculus.R
\name{calculus}
\alias{calculus}
\alias{+,Norm,Norm-method}
\alias{+,numeric,Norm-method}
\alias{+,Norm,numeric-method}
\alias{-,Norm,Norm-method}
\alias{-,numeric,Norm-method}
\alias{-,Norm,numeric-method}
\alias{*,numeric,Norm-method}
\alias{*,Norm,numeric-method}
\alias{/,Norm,numeric-method}
\alias{sum,Norm,logical-method}
\alias{exp,Norm-method}
\title{Distribution Calculus}
\usage{
\S4method{+}{Norm,Norm}(e1, e2)

\S4method{+}{numeric,Norm}(e1, e2)

\S4method{+}{Norm,numeric}(e1, e2)

\S4method{-}{Norm,Norm}(e1, e2)

\S4method{-}{numeric,Norm}(e1, e2)

\S4method{-}{Norm,numeric}(e1, e2)

\S4method{*}{numeric,Norm}(e1, e2)

\S4method{*}{Norm,numeric}(e1, e2)

\S4method{/}{Norm,numeric}(e1, e2)

\S4method{sum}{Norm,logical}(x, ..., na.rm = FALSE)

\S4method{exp}{Norm}(x)
}
\arguments{
\item{x, e1, e2}{objects of subclass \code{Distribution}.}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should missing values be removed?}
}
\value{
All calculations return Distribution objects (specifically, objects
of a class that is a subclass of \code{Distribution}), accordingly to the property
at hand.
}
\description{
Distribution Calculus
}
\examples{
# -----------------------------------------------------
# Distribution Calculus Example
# -----------------------------------------------------

library(estimators)

# Normal location - scale transformation
x <- Norm(mean = 2, sd = 3)
y <- 3 * x + 1 # Norm(mean = 7, sd = 9)

# Addition of two independent Normal random variables
x1 <- Norm(mean = 1, sd = 3)
x2 <- Norm(mean = 2, sd = 4)
x3 <- x1 + x2 # Norm(mean = 3, sd = 5)
}
