% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianza.R
\name{varianza}
\alias{varianza}
\title{Varianza.}
\usage{
varianza(x, variable = NULL, pesos = NULL, tipo = c("muestral", "cuasi"))
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere una sola variable, el argumento variable es NULL. En caso contrario, es necesario indicar el nombre o posición (número de columna) de la variable.}

\item{pesos}{Si los datos de la variable están resumidos en una distribución de frecuencias, debe indicarse la columna que representa los valores de la variable y la columna con las frecuencias o pesos.}

\item{tipo}{Es un carácter. Por defecto de calcula la varianza muestral (\code{tipo = "muestral"}). Si \code{tipo = "cuasi"}, se calcula la cuasivarianza muestral.}
}
\value{
Esta función devuelve un objeto de la clase \code{vector}. Si \code{tipo="muestral"}, devuelve la varianza muestral. Si \code{tipo="cuasi"}, devuelve la cuasi-varianza muestral.
}
\description{
Calcula la varianza.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrdispersion.png}{width = 200px}}
\if{latex}{\figure{qrdispersion.png}{options: width=3cm}}
}
\details{
(1) La expresión de la varianza muestral es:

\if{html}{\figure{varianza.png}{width = 320px}}
\if{latex}{\figure{varianza.png}{options: width=5cm}}

La varianza muestral así definida es el estimador máximo verosímil de la varianza de una población normal

(2) Muchos manuales y prácticamente todos los softwares (SPSS, Excel, etc.) calculan la expresión:

\if{html}{\figure{cuasivarianza.png}{width = 320px}}
\if{latex}{\figure{cuasivarianza.png}{options: width=5cm}}

Nosotros llamamos a esta medida: cuasi-varianza muestral y es un estimador insesgado de la varianza poblacional.
}
\note{
Si en lugar del tamaño muestral (n) se utiliza el tamaño de la población (N) se obtiene la varianza poblacional:


\if{html}{\figure{varianzapob.png}{width = 320px}}
\if{latex}{\figure{varianzapob.png}{options: width=5cm}}
}
\examples{

varianza1 <- varianza(startup[1])
varianza2 <- varianza(startup,variable=1)
varianza3 <- varianza(startup,variable=1, tipo="cuasi")

}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\seealso{
\code{\link{media}}, \code{\link{desviacion}}, \code{\link{coeficiente.variacion}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

\strong{Cristina Pardo-García}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
