% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{esmdata_preprocessed}
\alias{esmdata_preprocessed}
\title{Preprocessed ESM data set}
\format{
A data frame with 6 rows and 20 columns:
\describe{
\item{dyad}{Dyad identification number}
\item{id}{Participant identification number}
\item{role}{Role of a participant within a dyad, indicated by a character (0=father or 1=mother)}
\item{age}{Age of the participant}
\item{compliance}{Participant's proportion of completed surveys}
\item{obsno}{ESM questionnaire (beep) number indicating serial order}
\item{daycum}{Cumulative day count}
\item{beepno}{Beep number within a day}
\item{valid}{Indicator of observation validity (1=valid, 0=invalid)}
\item{scheduled}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was scheduled }
\item{sent}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was sent }
\item{start}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was opened by the participant }
\item{end}{Timestamps (e.g., “2023/04/14 10:23:47”) of when the ESM questionnaire was ended by the participant }
\item{pos_aff}{Positive affect score (0-100)}
\item{neg_aff}{Negative affect score (0-100)}
\item{perc_stress_child}{parents reported if their child did experience a stressful event since the last beep}
\item{perc_fun_child}{parents reported if their child had experienced anything fun since the last beep (yes/no)}
\item{perc_fun_signaled}{parents rated to which extent their child showed they experienced this fun event (0-100)}
\item{pos_aff_pc}{Person-centered positive affect score}
\item{neg_aff_pc}{Person-centered negative affect score}
}
}
\usage{
esmdata_preprocessed
}
\description{
This dataset has undergone random value alterations to ensure privacy and cannot be utilized for formal research purposes.
For additional information, refer to the associated article.
}
\keyword{datasets}
