% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refPlausible.R
\name{refPlausible}
\alias{refPlausible}
\title{refPlausible}
\usage{
refPlausible(refDf = NULL, units = "days", RELEVANTVN_REF)
}
\arguments{
\item{refDf}{a data.frame. The reference dataset.}

\item{units}{a character. This character must be exactly one of the following options: auto, secs, mins, hours, days, weeks. For more information see the R base function \code{\link{difftime}}.}

\item{RELEVANTVN_REF}{a list. This list is generated by function \code{\link{setREF}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
A data.frame, i.e. \code{refDf}. The returned data.frame will have two additional columns:
\enumerate{
\item ESM_PERIOD in the selected time period, e.g. days.
\item TIME_ANOMALY, i.e. a possible anomaly concerning the expected increase in the time sequence of the prompts in the reference dataset (returned only if there is at least one time anomaly).
\item PROMPT_NEXTDAY, i.e. at which of the participant's prompts is a time anomaly suspected (returned only if there is at least one time anomaly).
}
See \strong{Details} for more information.
}
\description{
refPlausible enables the user to quickly check the reference dataset concerning the expeced ESM time period for each participant.
}
\details{
The units of the ESM period can be selected by the user, namely one of the following: auto, secs, mins, hours, days, weeks. For more information enter ?difftime in the R console. The prompts per participant, as defined by the user within the reference dataset, are expected to be an increasing time series within a respective ESM day. Therefore, if there are two prompts set at the exact same time, this represents an anomaly. The same is true of any prompt that is earlier in time instead of later (as expected) than the previous prompt (time reversals are not tolerated). Finally, if the function detects any duplicates among the participant IDs, it will return an error message and displays the problematic lines of the reference dataset in the R console.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute refPlausible. Start ------
# Use example list delivered with the package
RELEVANTVN_REF <- RELEVANTVN_REFext
# Prerequisites in order to execute refPlausible. End --------
# ------------------------------------------------------
# Run function 8 of 29; see esmprep functions' hierarchy.
# ------------------------------------------------------
# In an ESM study all participants answer questionnaires during a time period which
# usually is equal across all participants (e.g. seven days). This function enables the
# user to check whether in the reference dataset the ESM period is plausible. For
# instance, a negative ESM time period would clearly be implausible, e.g. the user
# setting the beginning of the ESM time period after the end of it (which is
# impossible unless a functioning time machine is involved :-) ).
referenceDfNew1 <- refPlausible(refDf=referenceDfNew, units="days", RELEVANTVN_REF)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 8 of 29).
}
