% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDateTime.R
\name{genDateTime}
\alias{genDateTime}
\title{genDateTime}
\usage{
genDateTime(refOrEsDf = NULL, refOrEs = NULL, RELEVANTINFO_ES = NULL,
  RELEVANTVN_ES = NULL, RELEVANTVN_REF = NULL, dateFormat = "ymd",
  timeFormat = "HMS")
}
\arguments{
\item{refOrEsDf}{a data.frame. Either the reference dataset or the event sampling raw dataset (already merged to a single dataset).}

\item{refOrEs}{a character string. Enter "REF" if the argument refOrEs is the reference dataset, enter "ES" if it is the event sampling dataset.}

\item{RELEVANTINFO_ES}{a list. This list is generated by function \code{\link{setES}}.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{RELEVANTVN_REF}{a list. This list is generated by function \code{\link{setREF}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}

\item{dateFormat}{a character string. Choose the current date format, "ymd" (default), "mdy", or "dmy".}

\item{timeFormat}{a character string. Choose the current time format, "HMS" (default), or "HM".}
}
\value{
The dataset that was passed as first argument with two additional columns START_DATETIME and END_DATETIME, i.e. the date-time objects of the separated date and time of both ESM start and ESM end. See \strong{Details} for more information.
}
\description{
genDateTime generates a date-time object from the single components date and time.
}
\details{
Depending on whether the ESM dataset(s) or the reference dataset are passed as the first argument the start date and start time (same for end date and end time) doesn't have the same meaning. See definition of the date and time relating arguments in \code{\link{setES}} and \code{\link{setREF}}.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute genDateTime. Start --------------
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
imeiNumbers <- as.character(referenceDf$imei)
surveyNames <- c("morningTestGroup", "dayTestGroup", "eveningTestGroup",
"morningControlGroup", "dayControlGroup", "eveningControlGroup")
RELEVANT_ES <- setES(4, imeiNumbers, surveyNames, relEs)
RELEVANTINFO_ES <- RELEVANT_ES[["RELEVANTINFO_ES"]]
RELEVANTVN_ES <- RELEVANT_ES[["RELEVANTVN_ES"]]
esLs <- esList(list(morningControl, dayControl, eveningControl,
morningTest, dayTest, eveningTest), RELEVANTVN_ES)
keyLs <- genKey(esLs)
relRef <- relevantREFVN(ID="id", IMEI="imei", ST="st",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
RELEVANTVN_REF <- setREF(4, relRef)
# Prerequisites in order to execute genDateTime. End ----------------
# ------------------------------------------------------
# Run function 7 of 29; see esmprep functions' hierarchy.
# ------------------------------------------------------
# Applying function to reference dataset (7a of 29)
referenceDfList <- genDateTime(referenceDf, "REF", RELEVANTINFO_ES, RELEVANTVN_ES,
RELEVANTVN_REF)

# Extract reference dataset from output
referenceDfNew <- referenceDfList[["refOrEsDf"]]

# Extract extended list of relevant variables names of reference dataset
RELEVANTVN_REF <- referenceDfList[["extendedVNList"]]

# Applying function to raw ESM dataset(s) (7b of 29)
# keyLs is the result of function 'genKey'.
keyList <- genDateTime(keyLs, "ES", RELEVANTINFO_ES, RELEVANTVN_ES,
RELEVANTVN_REF)

# Extract list of raw ESM datasets from output
keyLsNew <- keyList[["refOrEsDf"]]

# Extract extended list of relevant variables names of raw ESM datasets
RELEVANTVN_ES <- keyList[["extendedVNList"]]
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 7 of 29).\cr \code{genDateTime} is the reverse function of \code{\link{splitDateTime}}.
}
