% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_regnie.R
\name{read_regnie}
\alias{read_regnie}
\title{Read DWD REGNIE gridded data into R}
\usage{
read_regnie(file)
}
\arguments{
\item{file}{path to gz archive}
}
\value{
A \code{RasterLayer} object.
}
\description{
This functions reads DWD REGNIE data.
A description of the data can be found here (pdf-format):
\url{https://www.dwd.de/DE/leistungen/regnie/download/regnie_beschreibung_pdf.pdf?__blob=publicationFile&v=2}.
Data is available here: \url{ftp://ftp-cdc.dwd.de/pub/CDC/grids_germany/daily/regnie/}.
}
\examples{
# Read daily precipitation on 20.01.2005.
r <- read_regnie(system.file("extdata", "ra050120.gz", package = "esmisc"))
}

