% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_spectrum.R
\name{signal_spectrum}
\alias{signal_spectrum}
\title{Calculate the spectrum of a time series}
\usage{
signal_spectrum(data, dt, method = "periodogram", n, res, log = FALSE, ...)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{dt}{\code{Numeric} value, sampling period. If omitted, \code{dt} 
is set to 1/200. Only needed if \code{data} is no \code{eseis} object.}

\item{method}{\code{Character} value, calculation method. One out of 
\code{"periodogram"} and \code{"autoregressive"}. 
default is \code{"periodogram"}.}

\item{n}{\code{Numeric} value, optional number of samples in 
running window used for smoothing the spectrogram. Only applied if a 
number is provided. Smoothing is performed as running mean.}

\item{res}{\code{Numeric} value, optional resolution of the spectrum, 
i.e. the number of power and frequency values. If omitted, the full 
resolution is returned. If used, a spline interpolation is performed.}

\item{log}{\code{Logical} value, option to interpolate the spectrum with 
log spaced frequency values. Default is \code{FALSE}.}

\item{\dots}{Additional arguments passed to the function.}
}
\value{
\code{Data frame} with frequency and power vector
}
\description{
The power spectral density estimate of the time series is calculated using 
different approaches.
}
\details{
If the \code{res} option is used, the frequency and power vectors will be 
interpolated using a spline interpolator, using equally spaced frequency 
values. If desired, the additional option \code{log = TRUE} can be used
to interpolate with log spaced frequency values.
}
\examples{

## load example data set
data(rockfall)

## calculate spectrum with standard setup
s <- signal_spectrum(data = rockfall_eseis)

## plot spectrum
plot_spectrum(data = s)

}
\author{
Michael Dietze
}
\keyword{eseis}
