% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_spectra.R
\name{fmi_spectra}
\alias{fmi_spectra}
\title{Create reference model spectra catalogue}
\usage{
fmi_spectra(parameters, n_cores = 1)
}
\arguments{
\item{parameters}{\code{List} containing lists with model parameters 
for which the spectra shall be calculated.}

\item{n_cores}{\code{Numeric} value, number of CPU cores to use. Disabled 
by setting to 1. Default is 1.}
}
\value{
\code{List} object containing the calculated reference spectra 
and the corresponding input parameters. Note that the spectra are given
in dB for a seamless comparison with the empirical PSD data, while the 
original output of the models are in linear scale.
}
\description{
In order to run the fluvial model inversion (FMI) routine, a look-up 
table with reference spectra needs to be created (based on predefined 
model parameters). This function does this job.
}
\examples{

## create 2 example reference parameter sets
ref_pars <- fmi_parameters(n = 2,
                           h_w = c(0.02, 2.00),
                           q_s = c(0.001, 50.000) / 2650,
                           d_s = 0.01,
                           s_s = 1.35,
                           r_s = 2650,
                           w_w = 6,
                           a_w = 0.0075,
                           f_min = 5,
                           f_max = 80,
                           r_0 = 6,
                           f_0 = 1,
                           q_0 = 10,
                           v_0 = 350,
                           p_0 = 0.55,
                           e_0 = 0.09,
                           n_0_a = 0.6,
                           n_0_b = 0.8,
                           res = 100)

## create corresponding reference spectra
ref_spectra <- fmi_spectra(parameters = ref_pars)

}
\author{
Michael Dietze
}
\keyword{eseis}
