% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.statistics.network.R
\name{summary.formula}
\alias{summary.formula}
\alias{summary}
\title{Calculation of network or graph statistics or other attributes
specified on a formula}
\usage{
\method{summary}{formula}(object, ...)
}
\arguments{
\item{object}{A formula having as its LHS a
\code{\link[network:network]{network}} object or a matrix that can be
coerced to a \code{\link[network:network]{network}} object, a
\code{\link{network.list}}, or other types to be summarized using a formula. (See
`methods('summary_formula') for the possible LHS types.}

\item{\dots}{further arguments passed to or used by methods.}
}
\value{
A vector of statistics specified in RHS of the formula.
}
\description{
Most generally, this function computes those summaries of the
object on the LHS of the formula that are specified by its RHS.  In
particular, if given a network as its LHS and
\code{\link{ergmTerm}} on its RHS, it computes the sufficient
statistics associated with those terms.
}
\details{
In practice, \code{\link[=summary.formula]{summary.formula()}} is a thin wrapper around the
\code{\link[=summary_formula]{summary_formula()}} generic, which dispatches methods based on the
class of the LHS of the formula.
}
\examples{

#
# Lets look at the Florentine marriage data
#
data(florentine)
#
# test the summary_formula function
#
summary(flomarriage ~ edges + kstar(2))
m <- as.matrix(flomarriage)
summary(m ~ edges)  # twice as large as it should be
summary(m ~ edges, directed=FALSE) # Now it's correct

}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link[network:network]{network()}}, \code{\link{ergmTerm}}
}
\keyword{models}
