% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{nodematch-ergmTerm}
\alias{nodematch-ergmTerm}
\alias{InitErgmTerm.nodematch}
\alias{InitWtErgmTerm.nodematch}
\alias{InitWtErgmTerm.match}
\alias{match-ergmTerm}
\title{Uniform homophily and differential homophily}
\usage{
# binary: nodematch(attr, diff=FALSE, keep=NULL, levels=NULL)

# valued: nodematch(attr, diff=FALSE, keep=NULL, levels=NULL, form="sum")

# valued: match(attr, diff=FALSE, keep=NULL, levels=NULL, form="sum")
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{diff}{specify if the term has uniform or differential homophily}

\item{keep}{deprecated}

\item{levels}{this optional argument controls which levels of the attribute should be included and which should be excluded. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{form}{how to aggregate tie values in a valued ERGM: \code{"sum"}
(the default) for a statistic of the form \eqn{\sum_{i,j} x_{i,j}
  y_{i,j}}{sum[i,j] x[i,j]*y[i,j]}, where \eqn{y_{i,j}}{y[i,j]} is
the value of dyad \eqn{(i,j)} and \eqn{x_{i,j}}{x[i,j]} is the
term's covariate associated with it; and \code{"nonzero"} with the
edge considered to be present if its value is not 0. See
\code{\link{ergmTerm}} for more information.}
}
\description{
When \code{diff=FALSE} , this term adds one network statistic
to the model, which counts the number of edges \eqn{(i,j)} for which
\code{attr(i)==attr(j)} . This is also called \dQuote{uniform homophily}, because each group is assumed to have the same propensity for within-group ties. When multiple attribute names are given, the
statistic counts only ties for which all of the attributes
match. When \code{diff=TRUE} , \eqn{p} network statistics are added
to the model, where \eqn{p} is the number of unique values of the
\code{attr} attribute. The \eqn{k} th such statistic counts the
number of edges \eqn{(i,j)} for which \verb{attr(i) == attr(j) == value(k)} , where \code{value(k)} is the \eqn{k} th
smallest unique value of the \code{attr} attribute. This is also called \dQuote{differential homophily}, because each group is allowed to have a unique propensity for within-group ties. Note that a statistical test of uniform vs. differential homophily should be conducted using the ANOVA function.

By default, matches on all levels \eqn{k} are
counted. This works for both
\code{diff=TRUE} and \code{diff=FALSE} .
}
\note{
The argument \code{keep} is retained for backwards compatibility and may be
removed in a future version. When both \code{keep} and \code{levels} are passed,
\code{levels} overrides \code{keep}. See \code{\link{nodal_attributes}}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "nodematch", "subsection")}
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{dyad-independent}
\concept{frequently-used}
\concept{undirected}
