% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.dgw_sp.R
\name{gwb2dspL-ergmTerm}
\alias{gwb2dspL-ergmTerm}
\alias{InitErgmTerm.gwb2dspL}
\title{Geometrically weighted dyadwise shared partner distribution for dyads in the second bipartition on layers}
\usage{
# binary: gwb2dspL(decay=0, fixed=FALSE, cutoff=30, Ls.path=NULL)
}
\arguments{
\item{decay}{nonnegative decay parameter for the shared partner counts; required if \code{fixed=TRUE} and ignored with a warning otherwise.}

\item{fixed}{optional argument indicating
whether the \code{decay} parameter is fixed at the given value, or is to be fit as a curved
exponential-family model (see Hunter and Handcock, 2006). The
default is \code{FALSE} , which means the scale parameter is not
fixed and thus the model is a curved exponential family.}

\item{cutoff}{This optional argument sets the number of underlying b2dsp terms
to use in computing the statistics when \code{fixed=FALSE}, in order to reduce
the computational burden.  Its default value can also be controlled by the
\code{gw.cutoff} term option control parameter. (See \code{?control.ergm}.)}

\item{Ls.path, L.in_order}{a vector of one or two formulas \code{Ls.path}
provides the Layer Logic (c.f. Layer Logic section in the
\code{\link[=Layer]{Layer()}} documentation) specifications for the ties of the
2-path or the shared partnership. (If only one formula is given
the layers are assumed to be the same.) If \code{L.in_order==TRUE} ,
the first tie of the two-path must be the first element of
\code{Ls.path} and the second must be the second; otherwise, any
ordering counts, provided there is exactly one of each. (For
types \code{"OSP"} and \code{"ISP"} , the first tie is considered to be the
one incident on the tail of the base tie.)}
}
\description{
This term adds one network statistic to the model equal to the geometrically
weighted dyadwise shared partner distribution for dyads in the second bipartition with decay parameter
\code{decay} parameter, which should be non-negative. This term can only be used with bipartite networks.
}
\note{
This term does not support multilayer networks with
heterogeneous bipartedness. This may change in the future.

This term takes an additional term option (see
\code{\link[ergm:ergm-options]{options?ergm}}), \code{cache.sp}, controlling whether
the implementation will cache the number of shared partners for
each dyad in the network; this is usually enabled by default.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "gwb2dspL", "subsection")}
}
\concept{bipartite}
\concept{curved}
\concept{layer-aware}
\concept{undirected}
