% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_devlin.R
\name{figure_1_2_4}
\alias{figure_1_2_4}
\title{Figure 1.2.4: Percentage of Respondents Who Had a Mixed Change Overall,
by Dimension Improved or Worsened, Grouped by Procedure (or Other Grouping)}
\usage{
figure_1_2_4(
  df,
  name_id,
  name_groupvar,
  names_eq5d = NULL,
  name_fu = NULL,
  levels_fu = NULL
)
}
\arguments{
\item{df}{Data frame containing columns for EQ-5D dimensions, a grouping variable,
a patient ID, and a follow-up variable}

\item{name_id}{Character string indicating the patient ID column}

\item{name_groupvar}{Character string for the grouping column (e.g. "procedure")}

\item{names_eq5d}{Character vector naming the EQ-5D dimensions (e.g. c("mo","sc","ua","pd","ad"))}

\item{name_fu}{Character string for the follow-up column (e.g. "time")}

\item{levels_fu}{Character vector of length 2 specifying the time order (e.g. c("Pre-op","Post-op"))}
}
\value{
A list with two elements:
  \item{plot_data}{A wide-format data frame of dimension-specific improvements/worsenings for "Mixed change"}
  \item{p}{A ggplot2 object showing a dimension-level bar chart from .pchc_plot_by_dim}
}
\description{
This function focuses on patients classified as having "Mixed change" overall
(i.e., some dimensions improved, others worsened). It then examines which dimensions
improved vs. worsened for each subject. Results are summarized by a grouping variable
(e.g., procedure) and time points. The final output is a table plus a ggplot object.
}
\examples{
result <- figure_1_2_4(
  df = example_data,
  name_id = "id",
  name_groupvar = "procedure",
  names_eq5d = c("mo","sc","ua","pd","ad"),
  name_fu = "time",
  levels_fu = c("Pre-op","Post-op")
)
result$plot_data
result$p

}
