% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_payback.R
\encoding{UTF-8}
\name{epe4md_payback}
\alias{epe4md_payback}
\title{Roda um fluxo de caixa para cada caso e retorna métricas financeiras.}
\usage{
epe4md_payback(
  casos_payback,
  premissas_reg,
  ano_base,
  sequencial,
  filtro_de_uf,
  filtro_de_segmento,
  filtro_de_custo_unitario_max,
  altera_sistemas_existentes = TRUE,
  ano_decisao_alteracao = 2023,
  inflacao = 0.0375,
  taxa_desconto_nominal = 0.13,
  custo_reforco_rede = 200,
  ano_troca_inversor = 11,
  pagamento_disponibilidade = 0.3,
  disponibilidade_kwh_mes = 100,
  desconto_capex_local = 0,
  anos_desconto = 0,
  dir_dados_premissas = NA_character_
)
}
\arguments{
\item{casos_payback}{data.frame. Base gerada pela função
\link{epe4md_casos_payback}}

\item{premissas_reg}{data.frame. Input de premissas regulatórias para serem
consideradas nos cálculos.}

\item{ano_base}{numeric. Ano base da projeção. Define o ano em que a função
irá buscar a base de dados. Último ano completo realizado.}

\item{sequencial}{logic. Parâmetro que define se a projeção deve ser
realizada de forma sequencial ou paralela. Para executar a projeção de forma
sequencial defina o parâmetro como TRUE. Para executar a projeção de forma
paralela, defina o parâmetro como FALSE.}

\item{filtro_de_uf}{string. Parâmetro que define uma unidade federativa (UF) a
ser filtrada. Caso uma UF não seja indicada ou seja informado um valor inválido,
o resultado será apresentado sem filtros.}

\item{filtro_de_segmento}{string. Parâmetro que define um segmento a ser
filtrado. Pode se escolher entre "comercial_at", "comercial_at_remoto",
"comercial_bt", "residencial" e "residencial_remoto".  Caso não seja
informado um valor ou seja informado um valor inválido o resultado será
apresentado sem filtro.}

\item{filtro_de_custo_unitario_max}{numeric. Parâmetro que define o valor
máximo do custo unitário para ser utilizado no cálculo do payback. Default
igual a NULL.}

\item{altera_sistemas_existentes}{logic. TRUE se alterações regulatórias
afetam investimentos realizados em anos anteriores à revisão da regulação.
Default igual a FALSE.}

\item{ano_decisao_alteracao}{numeric. Ano em que são definidas novas regras e
se tornam de conhecimento público. Esse parâmetro só tem efeito caso o
anterior seja igual a TRUE. Default igual a 2021.}

\item{inflacao}{mumeric. Taxa anual de inflacao considerada no reajuste das
tarifas e para calcular o retorno real de projetos. Default igual a 0.0375.}

\item{taxa_desconto_nominal}{numeric. Taxa de desconto nominal considerada
nos cálculos de payback descontado. Default igual a 0.13.}

\item{custo_reforco_rede}{numeric. Custo em R$/kW aplicado a projetos de
geracao remota em Alta Tensão. Representa um custo pago pelo empreendedor
para reforços na rede. Default igual a 200.}

\item{ano_troca_inversor}{numeric. Ano, a partir do ano de instalação, em que
é realizada a troca do inversor fotovoltaico. Default igual a 11.}

\item{pagamento_disponibilidade}{numeric. Percentual de meses em que o
consumidor residencial paga custo de disponbilidade em função da
variabilidade da geração FV. Default igual a 0.3. Tem efeito somente até o
ano de 2022.}

\item{disponibilidade_kwh_mes}{numeric. Consumo de disponbilidade do
consumidor em kWh/mês. Default igual a 100, equivalente a um consumidor
trifásico. Tem efeito somente até o ano de 2022.}

\item{desconto_capex_local}{numeric. Percentual de desconto a ser aplicado no
CAPEX de sistemas de geração local(ex: 0.1) para simulação de incentivos.
Default igual a 0.}

\item{anos_desconto}{vector. Anos em que há a incidência do desconto no
CAPEX. Default igual a 0.}

\item{dir_dados_premissas}{Diretório onde se encontram as premissas. Se esse
parâmetro não for passado, a função usa os dados default que são instalados
com o pacote. É importante que os nomes dos arquivos sejam os mesmos da
pasta default.}
}
\value{
data.frame. Métricas financeiras para cada caso.
}
\description{
Roda um fluxo de caixa para cada caso e retorna métricas financeiras.
}
\examples{

casos_payback <- tibble::tibble(
  segmento = "comercial_at",
  fonte_resumo = "Fotovoltaica",
  fator_autoconsumo = 0.8,
  oem_anual = 0.01,
  nome_4md = c("OUTRA", "RGE", "RORAIMA", "SULGIPE", "UHENPAL"),
  fc = c(0.1633388, 0.1513311, 0.1505592, 0.1649651, 0.1481121),
  vida_util = 25,
  degradacao = 0.005,
  pot_sistemas = 70,
  geracao_1_kwh = c(100159.36, 92796.22, 92322.91, 101156.62, 90822.36),
  ano = 2021,
  custo_unitario = 3.81,
  custo_inversor = 0.5715,
  capex_inicial = 266700,
  capex_inversor = 57808.98
)

premissas_regulatorias <- tibble::tibble(
  ano = 2021,
  alternativa = 0,
  p_transicao = 1.00,
  binomia = FALSE,
  demanda_g = FALSE
)

payback <- epe4md_payback(
  casos_payback = casos_payback,
  premissas_reg = premissas_regulatorias,
  ano_base = 2021,
  sequencial = TRUE,
  filtro_de_uf = "RR",
  filtro_de_segmento = "comercial_at",
  filtro_de_custo_unitario_max = 6,
  altera_sistemas_existentes = TRUE,
  ano_decisao_alteracao = 2023,
  inflacao = 0.0375,
  taxa_desconto_nominal = 0.13,
  custo_reforco_rede = 200,
  ano_troca_inversor = 11,
  pagamento_disponibilidade = 0.3,
  disponibilidade_kwh_mes = 100,
  desconto_capex_local = 0,
  anos_desconto = 0,
  dir_dados_premissas = NA_character_
)
}
