% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csem_compound_binomial.R
\name{csem_compound_binomial}
\alias{csem_compound_binomial}
\title{CSEM, CSSEM, and Reliability under the Compound Binomial Model}
\usage{
csem_compound_binomial(x, s, ct = NULL, w = NULL)
}
\arguments{
\item{x}{Examinee-by-item matrix/data frame of item responses, ordered by stratum.}

\item{s}{Numeric vector of number of items in each stratum. Sum(s) must equal ncol(x).}

\item{ct}{Optional conversion table with maxZ + 1 rows. The second column
is the scale score corresponding to composite score Z = 0, 1, ..., maxZ.}

\item{w}{Optional numeric vector of weights for each stratum. Defaults to 1 per stratum.}
}
\value{
A list containing:
\describe{
\item{x}{Raw total scores (row sums of x).}
\item{total_scale}{If \code{ct} is provided, the composite scale score for each examinee.}
\item{csem}{CSEM on the raw-score metric for each examinee.}
\item{cssem}{If \code{ct} is provided, CSSEM on the scale-score metric.}
\item{reliability_raw}{Reliability coefficient for raw scores.}
\item{reliability_scale}{If \code{ct} is provided, reliability coefficient
for scale scores.}
}
}
\description{
Compute the CSEM, CSSEM, and reliability coefficients for raw scores
and scaled scores using the full compound binomial error model.
}
\examples{
data(data.m)
data(ct.m)
csem_compound_binomial(data.m, c(13, 12, 6))
\donttest{
csem_compound_binomial(data.m, c(13, 12, 6), ct.m)
}

}
