% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_functions.R,
%   R/binary_method_functions.R, R/ordinal_method_functions.R,
%   R/continuous_method_functions.R
\name{pollinate_ML}
\alias{pollinate_ML}
\alias{pollinate_ML_binary}
\alias{pollinate_ML_ordinal}
\alias{pollinate_ML_continuous}
\title{Generate seed values for EM algorithm}
\usage{
pollinate_ML(
  type = c("binary", "ordinal", "continuous"),
  data,
  freqs = NULL,
  ...
)

pollinate_ML_binary(data, freqs = NULL, ...)

pollinate_ML_ordinal(
  data,
  freqs = NULL,
  n_level = NULL,
  threshold_level = ceiling(n_level/2),
  level_names = NULL,
  ...
)

pollinate_ML_continuous(
  data,
  freqs = NULL,
  prev = 0.5,
  q_seeds = c((1 - prev)/2, 1 - (prev/2)),
  high_pos = TRUE,
  ...
)
}
\arguments{
\item{type}{A string specifying the data type of the methods under evaluation.}

\item{data}{An \code{n_obs} by \code{n_method} \code{\link{matrix}} containing the
observed values for each method. If the dimensions are named, row names will
be used to name each observation (\code{obs_names}) and column names will be used
to name each measurement method (\code{method_names}).}

\item{freqs}{A vector of elements \code{n_obs} long representing the number of times
each row in \code{data} was observed. Used when \code{data} is a summary of unique response
combinations.}

\item{...}{Additional arguments}

\item{n_level}{Used for ordinal methods. Integer number of levels each method contains}

\item{threshold_level}{Used for ordinal methods. A value from 1 to \code{n_level} which
indicates the initial threshold used to define positive and negative disease states.}

\item{level_names}{Used for ordinal methods. Optional vector of length \code{n_level}
containing names for each level.}

\item{prev}{A double between 0-1 representing the proportion of positives in the population}

\item{q_seeds}{Used for continuous methods. A vector of length 2 representing the quantiles at which the two groups are assumed to be centered}

\item{high_pos}{Used for continuous methods. A logical indicating whether larger values are considered "positive"}
}
\value{
a list of EM algorithm initialization values
}
\description{
\code{pollinate_ML()} is a general helper function which can be used to generate starting
values, i.e. seeds, for the \code{estimate_ML()} function from a multi-method data set.
}
