% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{combination_data_frame}
\alias{combination_data_frame}
\title{Generate Matrix for Drug Combinations}
\usage{
combination_data_frame(cocktail, upperBound, data)
}
\arguments{
\item{cocktail}{An integer vector of drug indices representing the full 
combination to be analyzed.}

\item{upperBound}{An integer vector defining the ATC tree hierarchy bounds.}

\item{data}{A \code{Rcpp::DataFrame} containing patient records. It must 
include a column \code{"patientATC"} which is a list of integer vectors 
representing the drugs each patient is taking.}
}
\value{
A \code{Rcpp::DataFrame} where:
\itemize{
  \item Each column corresponds to a sub-combination of the input \code{cocktail}.
  \item Each row corresponds to a patient in the input \code{data}.
  \item Values are boolean indicators (represented as integers/logicals in R).
}
}
\description{
This function creates a logical data frame where each column represents a 
specific sub-combination of drugs derived from a given "cocktail." For each 
patient in the input data, it indicates (TRUE/FALSE) whether they were 
taking that specific combination based on the ATC hierarchy.
}
\details{
The function first generates all possible non-empty power-set combinations of the 
\code{cocktail} (e.g., for \eqn{\{1, 2\}}, it generates \eqn{\{1\}, \{2\}, \{1, 2\}}).
}
\note{
The column names of the resulting data frame are strings of comma-separated 
drug indices (e.g., "888,659,").
}
