% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/educabR-package.R
\docType{package}
\name{educabR-package}
\alias{educabR-package}
\alias{educabR}
\title{educabR: Download and Process Brazilian Education Data from INEP}
\description{
Download and process public education data from INEP (Instituto Nacional de Estudos e Pesquisas Educacionais Anísio Teixeira). Provides functions to access microdata from the School Census (Censo Escolar), ENEM (Exame Nacional do Ensino Médio), IDEB (Índice de Desenvolvimento da Educação Básica), and other educational datasets. Returns data in tidy format ready for analysis. Data source: INEP Open Data Portal \url{https://www.gov.br/inep/pt-br/acesso-a-informacao/dados-abertos}.

The educabR package provides functions to download and process public
education data from INEP (Instituto Nacional de Estudos e Pesquisas
Educacionais Anísio Teixeira). It offers easy access to microdata from:
\itemize{
\item \strong{School Census (Censo Escolar)}: Annual data on schools, enrollment,
teachers, and classes in basic education
\item \strong{ENEM}: Data from the National High School Exam
\item \strong{IDEB}: Basic Education Development Index
}

All functions return data in tidy format, ready for analysis with tidyverse
tools.
}
\section{Main functions}{


\strong{School Census:}
\itemize{
\item \code{\link[=get_censo_escolar]{get_censo_escolar()}}: Download School Census microdata
}

\strong{ENEM:}
\itemize{
\item \code{\link[=get_enem]{get_enem()}}: Download ENEM microdata
}

\strong{IDEB:}
\itemize{
\item \code{\link[=get_ideb]{get_ideb()}}: Download IDEB data
}
}

\section{Cache system}{


The package implements a local cache system to avoid repeated downloads.
Use \code{\link[=set_cache_dir]{set_cache_dir()}} to configure a persistent cache directory.
See \code{\link[=get_cache_dir]{get_cache_dir()}} to check the current cache location.
}

\section{Data source}{


All data is downloaded from INEP's official portal:
\url{https://www.gov.br/inep/pt-br/acesso-a-informacao/dados-abertos/microdados}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/SidneyBissoli/educabR}
  \item \url{https://sidneybissoli.github.io/educabR/}
  \item Report bugs at \url{https://github.com/SidneyBissoli/educabR/issues}
}

}
\author{
\strong{Maintainer}: Sidney da Silva Pereira Bissoli \email{sbissoli76@gmail.com} (\href{https://orcid.org/0009-0001-0442-3700}{ORCID})

}
\keyword{internal}
