% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{submission_index_href}
\alias{submission_index_href}
\alias{submission_href}
\alias{submission_file_href}
\title{Submission URL Tools}
\usage{
submission_index_href(cik, accession)

submission_href(cik, accession)

submission_file_href(cik, accession, filename)
}
\arguments{
\item{cik}{Company code}

\item{accession}{accession number for a filing}

\item{filename}{filename provided in a submission}
}
\value{
A string with URL requested
}
\description{
EDGAR submissions are organized fairly regularly. These functions help to
fint the URL to submission components.
}
\section{Functions}{
\itemize{
\item \code{submission_href}: Creates a link to the master submission
sgml submission file

\item \code{submission_file_href}: provides the link to a given file within a
particular submission.
}}

\examples{
submission_index_href("0000712515", "0000712515-17-000090")
submission_href("0000712515", "0000712515-17-000090")
submission_file_href("0000712515", "0000712515-17-000090",
                     "pressrelease-ueberroth.htm")
}
