% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base.R
\name{plot.tune_esn}
\alias{plot.tune_esn}
\title{Plot forecasts from a tuned ESN object}
\usage{
\method{plot}{tune_esn}(x, metric = "mse", ...)
}
\arguments{
\item{x}{An object of class \code{tune_esn}. The result of a call to \code{tune_esn()}.}

\item{metric}{Character value. The metric used to select the best hyperparameter combination (\code{metric = c("mse", "mae")}.}

\item{...}{Further arguments passed to \code{plot()}.}
}
\value{
Line chart of point forecast and actual values.
}
\description{
Plot actual values and the point forecasts from the best 
  hyperparameter combination selected via \code{tune.esn()} using the 
  selected accuracy metric. Forecasts are shown as separate line segments 
  for each test split, with vertical dashed lines marking the starts of test 
  windows.
}
\examples{
xdata <- as.numeric(AirPassengers)
fit <- tune_esn(
  y = xdata,
  n_ahead = 12,
  n_split = 5,
  alpha = c(0.5, 1),
  rho   = c(1.0),
  tau   = c(0.4),
  inf_crit = "bic"
)

plot(fit)

}
\seealso{
Other base functions: 
\code{\link{forecast_esn}()},
\code{\link{is.esn}()},
\code{\link{is.forecast_esn}()},
\code{\link{is.tune_esn}()},
\code{\link{plot.esn}()},
\code{\link{plot.forecast_esn}()},
\code{\link{print.esn}()},
\code{\link{summary.esn}()},
\code{\link{summary.tune_esn}()},
\code{\link{train_esn}()},
\code{\link{tune_esn}()}
}
\concept{base functions}
