% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{createRef}
\alias{createRef}
\title{Create reference citation for R packages}
\usage{
createRef(
  pkg,
  format = "ris",
  filename = NULL,
  overwrite = TRUE,
  verbose = FALSE,
  database = "auto"
)
}
\arguments{
\item{pkg}{Character vector of package names to process}

\item{format}{Output format: "ris", "bib", "bibtex", or "both" (default: "ris")}

\item{filename}{Output file path. If NULL, creates a default filename based on package name(s).
If no file extension is provided, one will be added based on the format.}

\item{overwrite}{Allow overwriting existing files (default: TRUE)}

\item{verbose}{Logical. If TRUE, prints detailed information about each step (default: FALSE)}

\item{database}{Repository to search: "auto" (default), "cran", or "bioconductor".
"auto" automatically detects the repository, "cran" searches only CRAN,
"bioconductor" searches only Bioconductor.}
}
\value{
Invisible list of results with package information and formatted citations. Always writes to file.
}
\description{
This is the main function to collect information about R packages and generate
citations in RIS or BibTeX format. Supports both CRAN and Bioconductor packages
with automatic DOI retrieval from GitHub repositories and published papers.
}
\examples{
\donttest{
# Generate RIS citation for a CRAN package
result <- createRef("ggplot2", filename = tempfile()) # Omit filename

# Generate citation for a Bioconductor package (requires BiocManager)
if (requireNamespace("BiocManager", quietly = TRUE)) {
  result <- createRef("Biobase", filename = tempfile())
}

# Generate both RIS and BibTeX for multiple packages
results <- createRef(c("ggplot2", "dplyr"), format = "both", filename = tempfile())

# Write to file (extension will be added automatically)
createRef("ggplot2", filename = tempfile()) # Replace with e.g. "ggplot2_citation"

# Verbose output showing each step (writes to default file)
createRef("ggplot2", verbose = TRUE, filename = tempfile()) # Omit filename

# Force search in specific repository
createRef("ggplot2", database = "cran", filename = tempfile()) # Omit filename
}
}
