% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_classes_and_methods.R
\name{get_epm_meta}
\alias{get_epm_meta}
\title{Get Meta Data from an easyPubMed Object.}
\usage{
get_epm_meta(x)
}
\arguments{
\item{x}{An `easyPubMed` object.}
}
\value{
a list including meta data from an `easyPubMed` object.
}
\description{
Request Meta Data from an `easyPubMed` object. This is a wrapper
function that calls the `getEPMMeta()` method. This function returns 
contents from the `meta` slot.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive. 
setTimeLimit(elapsed = 4.9)
try({
  x <- epm_query(query_string = 'Damiano Fantini[AU] AND "2018"[PDAT]')
  get_epm_meta(x)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

 
}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
