% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_earthtide.R
\name{calc_earthtide}
\alias{calc_earthtide}
\title{earthtide}
\usage{
calc_earthtide(
  utc,
  do_predict = TRUE,
  method = "gravity",
  latitude = 0,
  longitude = 0,
  elevation = 0,
  azimuth = 0,
  gravity = 0,
  earth_radius = 6378136.3,
  earth_eccen = 0.0066943979514,
  cutoff = 1e-06,
  wave_groups = NULL,
  catalog = "ksm04",
  eop = NULL,
  return_matrix = FALSE,
  scale = TRUE,
  n_thread = 1L,
  astro_update = 1L,
  utc_interp = NULL,
  ...
)
}
\arguments{
\item{utc}{The date-time in UTC (POSIXct vector).}

\item{do_predict}{run in predict or analyze mode}

\item{method}{One or more of "gravity",
"tidal_potential", "tidal_tilt", "vertical_displacement",
"horizontal_displacement", "n_s_displacement", "e_w_displacement",
"vertical_strain", "areal_strain", "volume_strain", "horizontal_strain",
or "ocean_tides", "pole_tide", "lod_tide". The pole tide and lod_tide
are used in predict mode even if do_predict is FALSE. More than one value
can only be used if do_predict == TRUE.}

\item{latitude}{The station latitude (numeric) defaults to 0.}

\item{longitude}{The station longitude (numeric) defaults to 0.}

\item{elevation}{The station elevation (m) (numeric) defaults to 0.}

\item{azimuth}{Earth azimuth (numeric) defaults to 0.}

\item{gravity}{Gravity at the station (m/s^2) (numeric) 0 to
estimate gravity from elevation and latitude.}

\item{earth_radius}{Radius of earth (m) (numeric) defaults to 6378136.3}

\item{earth_eccen}{Eccentricity of earth (numeric)
defaults to 6.69439795140e-3}

\item{cutoff}{Cutoff amplitude for constituents (numeric)
defaults to 1e-6.}

\item{wave_groups}{Two column data.frame having start and end of
frequency groups (data.frame). This data.frame must have two columns
with the names 'start', and 'end' signifying the start and end of the
wave groupings.  An optional third column 'multiplier' can be provided
to scale the particular wave group.  If column names do no match, the
inferred column positions are start, end, multiplier.}

\item{catalog}{Use the "hw95s" catalog or "ksm04" catalog (character).}

\item{eop}{User defined Earth Orientation Parameter (EOP) data.frame with the
following columns: datetime, ddt, ut1_utc, lod, x, y, dx, dy}

\item{return_matrix}{Return a matrix of tidal values instead of data.frame.
The datetime column will not be present in this case (logical).}

\item{scale}{Scale results when do_predict is FALSE}

\item{n_thread}{Number of threads to use for parallel processing (integer).}

\item{astro_update}{How often to update astro parameters in number of
samples. This speeds up code but may make it slightly less accurate.}

\item{utc_interp}{The date-time in UTC (POSIXct vector) to interpolate from
the initial utc values.}

\item{...}{Currently not used.}
}
\value{
data.frame or matrix of tidal results
}
\description{
This is a wrapper to the Earthtide R6 class for the prediction
of Earth tides. This function is provided for users who would prefer a more
typical R function.
}
\examples{
tms <- as.POSIXct("1990-01-01", tz = "UTC") + c(0, 3600)
wave_groups <- data.frame(start = 0, end = 8, multiplier = 1.5)

et <- calc_earthtide(
  utc = tms,
  do_predict = TRUE,
  method = c("tidal_potential", "lod_tide", "pole_tide"),
  latitude = 52.3868,
  longitude = 9.7144,
  elevation = 110,
  gravity = 9.8127,
  cutoff = 1.0e-5,
  catalog = "ksm04",
  wave_groups = wave_groups,
  n_thread = 1L
)
}
