% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BestVCGsize.R
\name{BestVCGsize}
\alias{BestVCGsize}
\title{The function attempts to find the optimal size for VCG.}
\usage{
BestVCGsize(formula, data = data, plot = TRUE)
}
\arguments{
\item{formula}{A formula specifying the treated and covariates, e.g., `treated ~ cov1 + cov2 | stratum`. The treated variable must be binary (0=pool, 1=treated)}

\item{data}{A data frame containing the variables specified in the formula.}

\item{plot}{Logical. If `TRUE`, returns a ggplot2 plot. Default: TRUE}
}
\value{
If `plot = TRUE`, returns a list with:
\item{optimal_n}{The estimated optimal VCG size (integer).}
\item{plot}{A ggplot2 object visualizing the energy distance curve and plateau.}
}
\description{
The function tries out different sizes of VCG and searches for the smallest distance.
}
\details{
It is only intended for exploratory purposes, as the VCG size is normally given.
But it can be used to see how well the given size fits.
The recommendation for VCG size is based solely on distance and does not take into account other aspects such as power or validity.
}
\examples{

set.seed(2342)
dat <- data.frame(
  treat = rep(0:1, c(50, 30)),
  cov1 = c(rnorm(50, 11, 2),  rnorm(30, 10, 1)),
  cov2 = c(rnorm(50, 12, 2),  rnorm(30, 10, 1)),
  cov3 = c(rnorm(50, 9,  2),  rnorm(30, 10, 1))
)
 BestVCGsize(treat ~ cov1 + cov2 + cov3, data=dat)

}
