% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_level.R
\name{apply_quality_ctrl}
\alias{apply_quality_ctrl}
\title{Apply quality control measures to a dataset}
\usage{
apply_quality_ctrl(
  data,
  id_var,
  class_tbl,
  bin_cats = NULL,
  min_freq = 1,
  to_numeric_matrix = FALSE
)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{id_var}{An unquoted  expression which corresponds to a variable (column) in
\code{data} which identifies each row (sample).}

\item{class_tbl}{data frame such as the output tibble from
\code{\link{assume_var_classes}} followed by
\code{\link{import_var_classes}}.}

\item{bin_cats}{Optional named vector of user-defined values for binary
values using \code{binary_label_1 = binary_label_2} syntax (e.g.
\code{c("No" = "Yes")} would assign level 1 to "No" and 2 to "Yes"). See
\code{\link{encode_binary_cats}} for defaults. Applied to variables (columns)
labelled "character" or "factor" in \code{class_tbl}.}

\item{min_freq}{Minimum frequency of occurrence
\code{\link{extract_freetext}} will use to extract groups of proximal
words in free-text from variables (columns) labelled "freetext" in \code{class_tbl}.}

\item{to_numeric_matrix}{Should QC'ed data be converted to a numeric matrix?
Default: FALSE.}
}
\value{
\code{data} with several QC measures applied.
}
\description{
The primary high level function for quality control. Applies several quality
control functions in sequence to input data frame (see Details for individual
functions).
}
\details{
The wrapped functions are applied in the following order:
\enumerate{
\item Standardise missing values (\code{\link{strings_to_NA}})
\item Encode binary categorical variables (columns) (\code{\link{encode_binary_cats}})
\item Encode (specific) ordinal variables (columns)(\code{\link{encode_ordinals}})
\item Encode genotype variables (\code{\link{encode_genotypes}})
\item Extract information from free text variables (columns) (\code{\link{extract_freetext}})
\item Encode non-binary categorical variables (columns) (\code{\link{encode_cats}})
\item Encode output as numeric matrix (optional, \code{\link{encode_as_num_mat}})
}

\code{class_tbl} is used to apply the above functions to the appropriate variables (columns).
}
\examples{
data(example_data)
require(tibble)

# create an example class_tbl object
# note that diabetes_type is classes as ordinal and is not modified as its
# levels are not pre-coded
tibble::tribble(~"var", ~"datatype",
"patient_id", "id",
"tumoursize", "numeric",
"t_stage", "ordinal_tstage",
"n_stage", "ordinal_nstage",
"diabetes", "factor",
"diabetes_type", "ordinal",
"hypertension", "factor",
"rural_urban", "factor",
"marital_status", "factor",
"SNP_a", "genotype",
"SNP_b", "genotype",
"free_text", "freetext") -> data_types

data_QC <- apply_quality_ctrl(example_data, patient_id, data_types, 
   bin_cats =c("No" = "Yes", "rural" = "urban"),  min_freq = 0.6)
}
\seealso{
Other high level functionality: 
\code{\link{assess_quality}()},
\code{\link{review_quality_ctrl}()},
\code{\link{semantic_enrichment}()}
}
\concept{high level functionality}
