# Generated by 03-tests.R

withr::local_envvar(DUCKPLYR_FORCE = "TRUE")

meta <- testthat::is_parallel() # Slow!
# meta <- TRUE

test_that("as_duckplyr_df_impl() and add_count()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% add_count()
  post <- test_df %>% add_count() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and add_count()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% add_count()
  post <- test_df %>% add_count() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and anti_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% anti_join(test_df_y, join_by(a))
  post <- test_df_x %>% anti_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and anti_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% anti_join(test_df_y, join_by(a))
  post <- test_df_x %>% anti_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and arrange()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% arrange()
  post <- test_df %>% arrange() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and arrange()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% arrange()
  post <- test_df %>% arrange() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and arrange(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% arrange(a)
  post <- test_df %>% arrange(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and arrange(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% arrange(g)
  post <- test_df %>% arrange(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and arrange(g, a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% arrange(g, a)
  post <- test_df %>% arrange(g, a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and arrange(a, g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% arrange(a, g)
  post <- test_df %>% arrange(a, g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and auto_copy()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% auto_copy(test_df_y)
  post <- test_df_x %>% auto_copy(test_df_y)

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and auto_copy()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% auto_copy(test_df_y)
  post <- test_df_x %>% auto_copy(test_df_y)

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and collapse()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% collapse()
  post <- test_df %>% collapse() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and collapse()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% collapse()
  post <- test_df %>% collapse() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and collect()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% collect()
  post <- test_df %>% collect()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and collect()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% collect()
  post <- test_df %>% collect()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and compute()", {
  # No fallback

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% compute()
  post <- test_df %>% compute() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and count()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% count()
  post <- test_df %>% count() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and count()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% count()
  post <- test_df %>% count() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and count(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% count(a)
  post <- test_df %>% count(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and count(b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% count(b)
  post <- test_df %>% count(b) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and count(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% count(g)
  post <- test_df %>% count(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and count(g, a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% count(g, a)
  post <- test_df %>% count(g, a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and count(b, g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% count(b, g)
  post <- test_df %>% count(b, g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and cross_join()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% cross_join(test_df_y)
  post <- test_df_x %>% cross_join(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and cross_join()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% cross_join(test_df_y)
  post <- test_df_x %>% cross_join(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and distinct()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% distinct()
  post <- test_df %>% distinct() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and distinct()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% distinct()
  post <- test_df %>% distinct() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and distinct(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% distinct(a)
  post <- test_df %>% distinct(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and distinct(a, b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% distinct(a, b)
  post <- test_df %>% distinct(a, b) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and distinct(b, b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% distinct(b, b)
  post <- test_df %>% distinct(b, b) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% distinct(g)
  post <- test_df %>% distinct(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and distinct(g, .keep_all = TRUE)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% distinct(g, .keep_all = TRUE)
  post <- test_df %>% distinct(g, .keep_all = TRUE) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and do(data.frame(c = 1))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% do(data.frame(c = 1))
  post <- test_df %>% do(data.frame(c = 1))

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and do(data.frame(c = 1))", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% do(data.frame(c = 1))
  post <- test_df %>% do(data.frame(c = 1))

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and dplyr_reconstruct(test_df)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Hack")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% dplyr_reconstruct(test_df)
  post <- test_df %>% dplyr_reconstruct(test_df)

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and filter(a == 1)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter(a == 1)
  post <- test_df %>% filter(a == 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter(a == 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter(a == 1)
  post <- test_df %>% filter(a == 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter(a %in% 2:3, g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter(a %in% 2:3, g == 2)
  post <- test_df %>% filter(a %in% 2:3, g == 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter(a %in% 2:3 & g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter(a %in% 2:3 & g == 2)
  post <- test_df %>% filter(a %in% 2:3 & g == 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter(a != 2 | g != 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter(a != 2 | g != 2)
  post <- test_df %>% filter(a != 2 | g != 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and filter_out(a == 1)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter_out(a == 1)
  post <- test_df %>% filter_out(a == 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter_out(a == 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter_out(a == 1)
  post <- test_df %>% filter_out(a == 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter_out(a %in% 2:3, g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter_out(a %in% 2:3, g == 2)
  post <- test_df %>% filter_out(a %in% 2:3, g == 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter_out(a %in% 2:3 & g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter_out(a %in% 2:3 & g == 2)
  post <- test_df %>% filter_out(a %in% 2:3 & g == 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and filter_out(a != 2 | g != 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% filter_out(a != 2 | g != 2)
  post <- test_df %>% filter_out(a != 2 | g != 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and full_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% full_join(test_df_y, join_by(a))
  post <- test_df_x %>% full_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and full_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% full_join(test_df_y, join_by(a))
  post <- test_df_x %>% full_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_by()", {
  skip("Grouped")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_by()
  post <- test_df %>% group_by() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_indices()", {
  skip("Special")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_indices()
  post <- test_df %>% group_indices() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_keys()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Special")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_keys()
  post <- test_df %>% group_keys() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_map(~ .x)", {
  skip("WAT")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_map(~ .x)
  post <- test_df %>% group_map(~ .x) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_modify(~ .x)", {
  skip("Grouped")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_modify(~ .x)
  post <- test_df %>% group_modify(~ .x) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_nest()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Always returns tibble")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_nest()
  post <- test_df %>% group_nest() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_size()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Special")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_size()
  post <- test_df %>% group_size() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_split()", {
  skip("WAT")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_split()
  post <- test_df %>% group_split() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_trim()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Grouped")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_trim()
  post <- test_df %>% group_trim() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and group_vars()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_vars()
  post <- test_df %>% group_vars()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and group_vars()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% group_vars()
  post <- test_df %>% group_vars()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and groups()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Special")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% groups()
  post <- test_df %>% groups() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and inner_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% inner_join(test_df_y, join_by(a))
  post <- test_df_x %>% inner_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and inner_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% inner_join(test_df_y, join_by(a))
  post <- test_df_x %>% inner_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and intersect()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% intersect(test_df_y)
  post <- test_df_x %>% intersect(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and intersect()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% intersect(test_df_y)
  post <- test_df_x %>% intersect(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and left_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% left_join(test_df_y, join_by(a))
  post <- test_df_x %>% left_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and left_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% left_join(test_df_y, join_by(a))
  post <- test_df_x %>% left_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and mutate()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate()
  post <- test_df %>% mutate() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate()
  post <- test_df %>% mutate() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(a + 1)
  post <- test_df %>% mutate(a + 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(a + 1, .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(a + 1, .by = g)
  post <- test_df %>% mutate(a + 1, .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = a + 1)
  post <- test_df %>% mutate(c = a + 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(`if` = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(`if` = a + 1)
  post <- test_df %>% mutate(`if` = a + 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(sum(a, na.rm = TRUE))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(sum(a, na.rm = TRUE))
  post <- test_df %>% mutate(sum(a, na.rm = TRUE)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(sum(a, na.rm = TRUE), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(sum(a, na.rm = TRUE), .by = g)
  post <- test_df %>% mutate(sum(a, na.rm = TRUE), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(mean(a, na.rm = TRUE))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(mean(a, na.rm = TRUE))
  post <- test_df %>% mutate(mean(a, na.rm = TRUE)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(mean(a, na.rm = TRUE), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(mean(a, na.rm = TRUE), .by = g)
  post <- test_df %>% mutate(mean(a, na.rm = TRUE), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(sd(a, na.rm = TRUE))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(sd(a, na.rm = TRUE))
  post <- test_df %>% mutate(sd(a, na.rm = TRUE)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(sd(a, na.rm = TRUE), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(sd(a, na.rm = TRUE), .by = g)
  post <- test_df %>% mutate(sd(a, na.rm = TRUE), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a))
  post <- test_df %>% mutate(lag(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a), .by = g)
  post <- test_df %>% mutate(lag(a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a))
  post <- test_df %>% mutate(lead(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a), .by = g)
  post <- test_df %>% mutate(lead(a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, 2))
  post <- test_df %>% mutate(lag(a, 2)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, 2), .by = g)
  post <- test_df %>% mutate(lag(a, 2), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, 2))
  post <- test_df %>% mutate(lead(a, 2)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, 2), .by = g)
  post <- test_df %>% mutate(lead(a, 2), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, 4))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, 4))
  post <- test_df %>% mutate(lag(a, 4)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, 4), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, 4), .by = g)
  post <- test_df %>% mutate(lag(a, 4), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, 4))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, 4))
  post <- test_df %>% mutate(lead(a, 4)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, 4), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, 4), .by = g)
  post <- test_df %>% mutate(lead(a, 4), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, default = 0))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, default = 0))
  post <- test_df %>% mutate(lag(a, default = 0)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, default = 0), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, default = 0), .by = g)
  post <- test_df %>% mutate(lag(a, default = 0), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, default = 1000))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, default = 1000))
  post <- test_df %>% mutate(lead(a, default = 1000)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, default = 1000), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, default = 1000), .by = g)
  post <- test_df %>% mutate(lead(a, default = 1000), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, order_by = a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, order_by = a))
  post <- test_df %>% mutate(lag(a, order_by = a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(a, order_by = a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(a, order_by = a), .by = g)
  post <- test_df %>% mutate(lag(a, order_by = a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, order_by = a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, order_by = a))
  post <- test_df %>% mutate(lead(a, order_by = a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(a, order_by = a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(a, order_by = a), .by = g)
  post <- test_df %>% mutate(lead(a, order_by = a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(min(a, na.rm = TRUE))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(min(a, na.rm = TRUE))
  post <- test_df %>% mutate(min(a, na.rm = TRUE)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(min(a, na.rm = TRUE), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(min(a, na.rm = TRUE), .by = g)
  post <- test_df %>% mutate(min(a, na.rm = TRUE), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(max(a, na.rm = TRUE))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(max(a, na.rm = TRUE))
  post <- test_df %>% mutate(max(a, na.rm = TRUE)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(max(a, na.rm = TRUE), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(max(a, na.rm = TRUE), .by = g)
  post <- test_df %>% mutate(max(a, na.rm = TRUE), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(a / b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(a / b)
  post <- test_df %>% mutate(a / b) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = 0, e = 1 / d, f = 0 / d, g = -1 / d)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = 0, e = 1 / d, f = 0 / d, g = -1 / d)
  post <- test_df %>% mutate(d = 0, e = 1 / d, f = 0 / d, g = -1 / d) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 0, d = -1, e = log(c), f = suppressWarnings(log(d)))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 0, d = -1, e = log(c), f = suppressWarnings(log(d)))
  post <- test_df %>% mutate(c = 0, d = -1, e = log(c), f = suppressWarnings(log(d))) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 0, d = -1, e = log10(c), f = suppressWarnings(log10(d)))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 0, d = -1, e = log10(c), f = suppressWarnings(log10(d)))
  post <- test_df %>% mutate(c = 0, d = -1, e = log10(c), f = suppressWarnings(log10(d))) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 10, d = log(c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 10, d = log(c))
  post <- test_df %>% mutate(c = 10, d = log(c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 10, d = log10(c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 10, d = log10(c))
  post <- test_df %>% mutate(c = 10, d = log10(c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = NA_character_, d = grepl('.', c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = NA_character_, d = grepl('.', c))
  post <- test_df %>% mutate(c = NA_character_, d = grepl('.', c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 'abbc', d = gsub('(b|c)', 'z' , c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 'abbc', d = gsub('(b|c)', 'z' , c))
  post <- test_df %>% mutate(c = 'abbc', d = gsub('(b|c)', 'z' , c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 'abbc', d = sub('(b|c)', 'z' , c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 'abbc', d = sub('(b|c)', 'z' , c))
  post <- test_df %>% mutate(c = 'abbc', d = sub('(b|c)', 'z' , c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = NA_character_, d = gsub('.', '-' , c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = NA_character_, d = gsub('.', '-' , c))
  post <- test_df %>% mutate(c = NA_character_, d = gsub('.', '-' , c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = NA_character_, d = sub('.', '-' , c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = NA_character_, d = sub('.', '-' , c))
  post <- test_df %>% mutate(c = NA_character_, d = sub('.', '-' , c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = a %in% NA_real_)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = a %in% NA_real_)
  post <- test_df %>% mutate(d = a %in% NA_real_) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = a %in% NULL)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = a %in% NULL)
  post <- test_df %>% mutate(d = a %in% NULL) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = a %in% integer())", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = a %in% integer())
  post <- test_df %>% mutate(d = a %in% integer()) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = NA_real_, e = is.na(d))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = NA_real_, e = is.na(d))
  post <- test_df %>% mutate(d = NA_real_, e = is.na(d)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = row_number())", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = row_number())
  post <- test_df %>% mutate(d = row_number()) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = row_number(), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = row_number(), .by = g)
  post <- test_df %>% mutate(d = row_number(), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = n())", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = n())
  post <- test_df %>% mutate(d = n()) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = n(), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = n(), .by = g)
  post <- test_df %>% mutate(d = n(), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = .data$b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = .data$b)
  post <- test_df %>% mutate(c = .data$b) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = NA)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = NA)
  post <- test_df %>% mutate(d = NA) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = NA_integer_)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = NA_integer_)
  post <- test_df %>% mutate(d = NA_integer_) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = NA_real_)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = NA_real_)
  post <- test_df %>% mutate(d = NA_real_) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = NA_character_)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = NA_character_)
  post <- test_df %>% mutate(d = NA_character_) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = if_else(a > 1, \"ok\", NA))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = if_else(a > 1, "ok", NA))
  post <- test_df %>% mutate(d = if_else(a > 1, "ok", NA)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(mean(x = a, na.rm = TRUE))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(mean(x = a, na.rm = TRUE))
  post <- test_df %>% mutate(mean(x = a, na.rm = TRUE)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(mean(na.rm = TRUE, x = a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(mean(na.rm = TRUE, x = a))
  post <- test_df %>% mutate(mean(na.rm = TRUE, x = a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(sum(na.rm = TRUE, a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(sum(na.rm = TRUE, a))
  post <- test_df %>% mutate(sum(na.rm = TRUE, a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(min(na.rm = TRUE, a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(min(na.rm = TRUE, a))
  post <- test_df %>% mutate(min(na.rm = TRUE, a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(max(na.rm = TRUE, a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(max(na.rm = TRUE, a))
  post <- test_df %>% mutate(max(na.rm = TRUE, a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(sd(na.rm = TRUE, x = a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(sd(na.rm = TRUE, x = a))
  post <- test_df %>% mutate(sd(na.rm = TRUE, x = a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 'abbc', d = grepl(pattern = 'b', x = c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 'abbc', d = grepl(pattern = 'b', x = c))
  post <- test_df %>% mutate(c = 'abbc', d = grepl(pattern = 'b', x = c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 'abbc', d = sub(pattern = 'b', replacement = 'z', x = c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 'abbc', d = sub(pattern = 'b', replacement = 'z', x = c))
  post <- test_df %>% mutate(c = 'abbc', d = sub(pattern = 'b', replacement = 'z', x = c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(c = 'abbc', d = gsub(pattern = 'b', replacement = 'z', x = c))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(c = 'abbc', d = gsub(pattern = 'b', replacement = 'z', x = c))
  post <- test_df %>% mutate(c = 'abbc', d = gsub(pattern = 'b', replacement = 'z', x = c)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = if_else(condition = a > 1, true = \"ok\", false = \"no\"))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = if_else(condition = a > 1, true = "ok", false = "no"))
  post <- test_df %>% mutate(d = if_else(condition = a > 1, true = "ok", false = "no")) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lag(x = a, n = 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lag(x = a, n = 2))
  post <- test_df %>% mutate(lag(x = a, n = 2)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(lead(x = a, n = 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(lead(x = a, n = 2))
  post <- test_df %>% mutate(lead(x = a, n = 2)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = round(a + 0.5))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = round(a + 0.5))
  post <- test_df %>% mutate(d = round(a + 0.5)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = round(a / 10 + 0.04, digits = 1))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = round(a / 10 + 0.04, digits = 1))
  post <- test_df %>% mutate(d = round(a / 10 + 0.04, digits = 1)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and mutate(d = round(a, digits = -1))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% mutate(d = round(a, digits = -1))
  post <- test_df %>% mutate(d = round(a, digits = -1)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and n_groups()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Special")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% n_groups()
  post <- test_df %>% n_groups() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and nest_by()", {
  skip("WAT")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% nest_by()
  post <- test_df %>% nest_by() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and nest_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% nest_join(test_df_y, join_by(a))
  post <- test_df_x %>% nest_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and nest_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% nest_join(test_df_y, join_by(a))
  post <- test_df_x %>% nest_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and pull()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% pull()
  post <- test_df %>% pull()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and pull()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% pull()
  post <- test_df %>% pull()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and reframe()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% reframe()
  post <- test_df %>% reframe()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and reframe()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% reframe()
  post <- test_df %>% reframe()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and relocate(g)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% relocate(g)
  post <- test_df %>% relocate(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and relocate(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% relocate(g)
  post <- test_df %>% relocate(g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and relocate(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% relocate(a)
  post <- test_df %>% relocate(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and relocate(g, .before = b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% relocate(g, .before = b)
  post <- test_df %>% relocate(g, .before = b) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and relocate(a:b, .after = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% relocate(a:b, .after = g)
  post <- test_df %>% relocate(a:b, .after = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rename()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% rename()
  post <- test_df %>% rename() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rename()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% rename()
  post <- test_df %>% rename() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rename(c = a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% rename(c = a)
  post <- test_df %>% rename(c = a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rename_with(identity)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% rename_with(identity)
  post <- test_df %>% rename_with(identity) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rename_with(identity)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% rename_with(identity)
  post <- test_df %>% rename_with(identity) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and right_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% right_join(test_df_y, join_by(a))
  post <- test_df_x %>% right_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and right_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% right_join(test_df_y, join_by(a))
  post <- test_df_x %>% right_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rows_append()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_append(test_df_y)
  post <- test_df_x %>% rows_append(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rows_append()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_append(test_df_y)
  post <- test_df_x %>% rows_append(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rows_delete(by = c(\"a\", \"b\"), unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore")
  post <- test_df_x %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rows_delete(by = c(\"a\", \"b\"), unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore")
  post <- test_df_x %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rows_insert(by = \"a\", conflict = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_insert(test_df_y, by = "a", conflict = "ignore")
  post <- test_df_x %>% rows_insert(test_df_y, by = "a", conflict = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rows_insert(by = \"a\", conflict = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_insert(test_df_y, by = "a", conflict = "ignore")
  post <- test_df_x %>% rows_insert(test_df_y, by = "a", conflict = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rows_patch(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_patch(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_patch(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rows_patch(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_patch(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_patch(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rows_update(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_update(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_update(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rows_update(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_update(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_update(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rows_upsert(by = \"a\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_upsert(test_df_y, by = "a")
  post <- test_df_x %>% rows_upsert(test_df_y, by = "a") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and rows_upsert(by = \"a\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% rows_upsert(test_df_y, by = "a")
  post <- test_df_x %>% rows_upsert(test_df_y, by = "a") %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and rowwise()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Stack overflow")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% rowwise()
  post <- test_df %>% rowwise() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and sample_frac()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Random seed")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% sample_frac()
  post <- test_df %>% sample_frac() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and sample_n(size = 1)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Random seed")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% sample_n(size = 1)
  post <- test_df %>% sample_n(size = 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and select(a)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% select(a)
  post <- test_df %>% select(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and select(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% select(a)
  post <- test_df %>% select(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and select(-g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% select(-g)
  post <- test_df %>% select(-g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and select(everything())", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% select(everything())
  post <- test_df %>% select(everything()) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and semi_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% semi_join(test_df_y, join_by(a))
  post <- test_df_x %>% semi_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and semi_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% semi_join(test_df_y, join_by(a))
  post <- test_df_x %>% semi_join(test_df_y, join_by(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and setdiff()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% setdiff(test_df_y)
  post <- test_df_x %>% setdiff(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and setdiff()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% setdiff(test_df_y)
  post <- test_df_x %>% setdiff(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and setequal()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% setequal(test_df_y)
  post <- test_df_x %>% setequal(test_df_y)

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and setequal()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% setequal(test_df_y)
  post <- test_df_x %>% setequal(test_df_y)

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and slice()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice()
  post <- test_df %>% slice() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and slice()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice()
  post <- test_df %>% slice() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and slice_head(n = 2)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice_head(n = 2)
  post <- test_df %>% slice_head(n = 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and slice_head(n = 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice_head(n = 2)
  post <- test_df %>% slice_head(n = 2) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and slice_max(a)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice_max(a)
  post <- test_df %>% slice_max(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and slice_min(a)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice_min(a)
  post <- test_df %>% slice_min(a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and slice_sample()", {
  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice_sample()
  post <- test_df %>% slice_sample() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and slice_tail()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% slice_tail()
  post <- test_df %>% slice_tail() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and summarise(c = mean(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(c = mean(a))
  post <- test_df %>% summarise(c = mean(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(c = mean(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(c = mean(a))
  post <- test_df %>% summarise(c = mean(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(c = mean(a), .by = b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(c = mean(a), .by = b)
  post <- test_df %>% summarise(c = mean(a), .by = b) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(c = mean(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(c = mean(a), .by = g)
  post <- test_df %>% summarise(c = mean(a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(c = 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(c = 1)
  post <- test_df %>% summarise(c = 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(c = 1, .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(c = 1, .by = g)
  post <- test_df %>% summarise(c = 1, .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(n = n(), n = n() + 1L, .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(n = n(), n = n() + 1L, .by = g)
  post <- test_df %>% summarise(n = n(), n = n() + 1L, .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(n = n(), n = n() + 1L)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(n = n(), n = n() + 1L)
  post <- test_df %>% summarise(n = n(), n = n() + 1L) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(first(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(first(a))
  post <- test_df %>% summarise(first(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(first(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(first(a), .by = g)
  post <- test_df %>% summarise(first(a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(first(a, order_by = a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(first(a, order_by = a), .by = g)
  post <- test_df %>% summarise(first(a, order_by = a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(last(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(last(a))
  post <- test_df %>% summarise(last(a)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(last(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(last(a), .by = g)
  post <- test_df %>% summarise(last(a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(last(a, order_by = a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(last(a, order_by = a), .by = g)
  post <- test_df %>% summarise(last(a, order_by = a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(nth(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(nth(a, 2))
  post <- test_df %>% summarise(nth(a, 2)) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(nth(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(nth(a, 2), .by = g)
  post <- test_df %>% summarise(nth(a, 2), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and summarise(nth(a, 2, order_by = a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% summarise(nth(a, 2, order_by = a), .by = g)
  post <- test_df %>% summarise(nth(a, 2, order_by = a), .by = g) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and symdiff()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% symdiff(test_df_y)
  post <- test_df_x %>% symdiff(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and symdiff()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% symdiff(test_df_y)
  post <- test_df_x %>% symdiff(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and tally()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% tally()
  post <- test_df %>% tally() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and tally()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% tally()
  post <- test_df %>% tally() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and tbl_vars()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% tbl_vars()
  post <- test_df %>% tbl_vars()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and tbl_vars()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% tbl_vars()
  post <- test_df %>% tbl_vars()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and transmute(c = a + 1)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% transmute(c = a + 1)
  post <- test_df %>% transmute(c = a + 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and transmute(c = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% transmute(c = a + 1)
  post <- test_df %>% transmute(c = a + 1) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and transmute(row = a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% transmute(row = a)
  post <- test_df %>% transmute(row = a) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and ungroup()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Grouped")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df_impl() %>% ungroup()
  post <- test_df %>% ungroup() %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and union()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% union(test_df_y)
  post <- test_df_x %>% union(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and union()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% union(test_df_y)
  post <- test_df_x %>% union(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})

test_that("as_duckplyr_df_impl() and union_all()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% union_all(test_df_y)
  post <- test_df_x %>% union_all(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})


test_that("as_duckplyr_df_impl() and union_all()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df_impl() %>% union_all(test_df_y)
  post <- test_df_x %>% union_all(test_df_y) %>% as_duckplyr_df_impl()

  # Compare
  expect_identical(pre, post)
})
