% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise-rd.R, R/summarise.R
\name{summarise.duckplyr_df}
\alias{summarise.duckplyr_df}
\title{Summarise each group down to one row}
\usage{
\method{summarise}{duckplyr_df}(.data, ..., .by = NULL, .groups = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A data frame with 1 row, to add multiple columns from a single expression.
}}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.groups}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Grouping structure of the
result.
\itemize{
\item \code{"drop_last"}: drops the last level of grouping. This was the
only supported option before version 1.0.0.
\item \code{"drop"}: All levels of grouping are dropped.
\item \code{"keep"}: Same grouping structure as \code{.data}.
\item \code{"rowwise"}: Each row is its own group.
}

When \code{.groups} is not specified, it is set to \code{"drop_last"} for a grouped
data frame, and \code{"keep"} for a rowwise data frame. In addition, a message
informs you of how the result will be grouped unless the result is
ungrouped, the option \code{"dplyr.summarise.inform"} is set to \code{FALSE}, or when
\code{summarise()} is called from a function in a package.}
}
\description{
This is a method for the \code{\link[dplyr:summarise]{dplyr::summarise()}} generic.
See "Fallbacks" section for differences in implementation.
\code{summarise()} creates a new data frame.
It returns one row for each combination of grouping variables;
if there are no grouping variables,
the output will have a single row summarising all observations in the input.
It will contain one column for each grouping variable
and one column for each of the summary statistics that you have specified.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{summarise.duckplyr_df()}
\itemize{
\item with \code{.groups = "rowwise"}.
}

These features fall back to \code{\link[dplyr:summarise]{dplyr::summarise()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
summarise(mtcars, mean = mean(disp), n = n())
}
\seealso{
\code{\link[dplyr:summarise]{dplyr::summarise()}}
}
